<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array $params)
 * @method detailByParams(array $params)
 * @method canUserMarketCardStoreByParams(array $params)
 * @method listByParams(array $params)
 * @method subcompanyAllByParams(array $params)
 * @method storeClassificationListByParams(array $params)
 * @method getGroupsByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据分组获取门店(不传参数则为全部)
     *
     * @support  string $classification 分组维度(填写该参数后sc_id无效) 
     * @support  int $sc_id 分组id [Original type uint] 
     * @support  bool $include_delete 是否包含删除 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 获取门店信息
     *
     * @param  int $id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 获取可用商场卡门店
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function canUserMarketCardStore () {
        return self::getClass()->canUserMarketCardStore();
    }

    /**
     * 获取门店列表
     *
     * @support  string $name 店名 
     * @support  int $group_id 集团ID [Original type uint] 
     * @support  string $affiliate_type 加盟类型 
     * @support  int $province_id 省份ID [Original type uint] 
     * @support  int $city_id 城市ID [Original type uint] 
     * @support  int $area_id 运营区域ID [Original type uint] 
     * @support  int $city_type_id 城市类型ID [Original type uint] 
     * @support  string $store_type 品牌 
     * @support  string $status 门店状态 
     * @support  int $page 页数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 查询子公司(不带分页)
     *
     * @support  int $id 公司id 
     * @support  string $name 公司名称 
     * @throws  \Exception
     * @return  array
     */
    public static function subcompanyAll () {
        return self::getClass()->subcompanyAll();
    }

    /**
     * 根据区域类型获取门店分类列表
     *
     * @param  string $type 区域划分类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeClassificationList (string $type = 'price_area') {
        return self::getClass()->storeClassificationList([
            "type" => $type,
        ]);
    }

    /**
     * 集团列表
     *
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 数量 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroups () {
        return self::getClass()->getGroups();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}