<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array $params)
 * @method detailByParams(array $params)
 * @method canUserMarketCardStoreByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据分组获取门店(不传参数则为全部)
     *
     * @support  string $classification 分组维度(填写该参数后sc_id无效) 
     * @support  int $sc_id 分组id [Original type uint] 
     * @support  bool $include_delete 是否包含删除 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 获取门店信息
     *
     * @param  int $id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 获取可用商场卡门店
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function canUserMarketCardStore () {
        return self::getClass()->canUserMarketCardStore();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}