<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method detailByIdsByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method getDetailByCodeByParams(array $params)
 * @method getRetailActivityProductsByParams(array $params)
 */
class RetailProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 产品详情
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 批量产品详情
     *
     * @param  array $ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByIds (array $ids) {
        return self::getClass()->detailByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 产品分页列表
     *
     * @support  int $page 当前页 
     * @support  int $page_size 页内条数 
     * @support  string $name 名称(模糊查询) 
     * @support  int $category_id 品类ID [Original type uint] 
     * @support  string $status 产品状态 
     * @support  bool $show_deleted 是否显示已删除信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 产品列表
     *
     * @support  string $name 名称(模糊查询) 
     * @support  int $category_id 品类ID [Original type uint] 
     * @support  string $status 产品状态 
     * @support  bool $show_deleted 是否显示已删除信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 通过产品编码获取产品详情
     *
     * @param  string $product_code 产品编码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDetailByCode (string $product_code) {
        return self::getClass()->getDetailByCode([
            "product_code" => $product_code,
        ]);
    }

    /**
     * 获取活动产品
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRetailActivityProducts () {
        return self::getClass()->getRetailActivityProducts();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\RetailProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\RetailProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}