<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method doRequestToNsByParams(array $params)
 * @method syncStockInByParams(array $params)
 * @method syncStockCountAndFixedAssetCountByParams(array $params)
 * @method addInventoryTaskLogByParams(array $params)
 * @method updateByParams(array $params)
 */
class TaskLog {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 执行记录里面的同步
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function doRequestToNs () {
        return self::getClass()->doRequestToNs();
    }

    /**
     * 定时执行入库操作
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncStockIn () {
        return self::getClass()->syncStockIn();
    }

    /**
     * 同步物料库存和固定资产库存
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncStockCountAndFixedAssetCount () {
        return self::getClass()->syncStockCountAndFixedAssetCount();
    }

    /**
     * 盘点审核通过后,进行库存的同步操作
     *
     * @param  array $inventoryIds 盘点ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addInventoryTaskLog (array $inventoryIds) {
        return self::getClass()->addInventoryTaskLog([
            "inventoryIds" => $inventoryIds,
        ]);
    }

    /**
     * update
     *
     * @param  int $id tasklog记录id [Original type uint] [ require true ]
     * @support  array $requestInfo 请求参数 
     * @support  array $responseInfo 响应结果 
     * @support  int $isSuccess 是否成功 [Original type uint] 
     * @support  int $requestTimes 已请求次数 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Erp\TaskLog');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Erp\TaskLog');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}