<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method verifyOrderByParams(array $params)
 * @method detailByNumByParams(array $params)
 * @method changeNoteByParams(array $params)
 * @method changeAddressByParams(array $params)
 * @method createByParams(array $params)
 * @method groupOrderCreateByParams(array $params)
 * @method bindUserByParams(array $params)
 * @method unbindUserByParams(array $params)
 * @method updateUserByParams(array $params)
 * @method submitByParams(array $params)
 * @method cancelByParams(array $params)
 * @method paidByParams(array $params)
 * @method startByParams(array $params)
 * @method closeByParams(array $params)
 * @method finishByParams(array $params)
 * @method recoverWaitShootingByParams(array $params)
 * @method recoverFinishedToWaitShootingByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method changeUserDataByParams(array $params)
 * @method removeByParams(array $params)
 * @method getCanUseCouponListByParams(array $params)
 * @method getCanUseProductCardListByParams(array $params)
 * @method calCouponDeductionInfoByParams(array $params)
 * @method calProductDeductionInfoByParams(array $params)
 * @method calInteriorCouponDeductionInfoByParams(array $params)
 * @method workloadsByParams(array $params)
 * @method checkUserSubscribeByParams(array $params)
 * @method getEncryptOrderNumByParams(array $params)
 * @method getShortUrlByParams(array $params)
 * @method sendPayLinkByParams(array $params)
 * @method resetByParams(array $params)
 * @method workloadDetailByParams(array $params)
 * @method changeReserveTimeWhenNoSubmitByParams(array $params)
 * @method reserveProductCountByParams(array $params)
 * @method changeProductByParams(array $params)
 * @method jxjyCouponByParams(array $params)
 * @method getProductDiscountByIdsByParams(array $params)
 * @method operateLogByParams(array $params)
 * @method createPayMaxPaymentByParams(array $params)
 * @method payMaxCallbackByParams(array $params)
 * @method getOrderClothByParams(array $params)
 * @method updateOrderClothByParams(array $params)
 * @method itemsCheckByParams(array $params)
 * @method cronCallByParams(array $params)
 * @method checkCallStatusByParams(array $params)
 * @method cronRedialByParams(array $params)
 * @method hookNotifyCallByParams(array $params)
 * @method callOrderUserByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单列表查询
     *
     * @support  string $order_no 订单号 
     * @support  string $reserve_time_start 预约开始时间 
     * @support  string $reserve_time_end 预约结束时间 
     * @support  string $create_time_start 查询开始时间 
     * @support  string $create_time_end 查询结束时间 
     * @support  string $status 订单状态 
     * @support  string $status_list 订单状态 
     * @support  string $user_name 下单用户 
     * @support  string $user_phone 手机号 
     * @support  string $module 模块 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @support  string $sort_field 排序字段 
     * @support  bool $sort_desc 是否倒序 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取订单详情
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $mode 打印模式 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id, string $mode = '') {
        return self::getClass()->detail([
            "id" => $id,
            "mode" => $mode,
        ]);
    }

    /**
     * 核销订单
     *
     * @support  int $order_id 订单号 [Original type uint] [ require true ]
     * @support  string $activity_type 核销活动类型 [ require true ]
     * @support  string $type 核销产品类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function verifyOrder () {
        return self::getClass()->verifyOrder();
    }

    /**
     * 通过订单号获取订单详情
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @support  bool $with_del 是否包含删除 
     * @throws  \Exception
     * @return  array
     */
    public static function detailByNum () {
        return self::getClass()->detailByNum();
    }

    /**
     * 修改订单备注
     *
     * @support  int $id 订单id [Original type uint] [ require true ]
     * @support  string $note 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeNote () {
        return self::getClass()->changeNote();
    }

    /**
     * 修改外拍订单地址
     *
     * @support  int $id 订单id [Original type uint] [ require true ]
     * @support  string $outside_city 拍摄城市 [ require true ]
     * @support  string $outside_address 拍摄地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeAddress () {
        return self::getClass()->changeAddress();
    }

    /**
     * 创建订单（管理端开单）
     *
     * @support  int $user_id 用户ID 
     * @support  string $user_phone 用户手机号 [ require true ]
     * @support  string $user_sex 用户性别 [ require true ]
     * @support  string $user_name 用户姓名 [ require true ]
     * @support  string $user_birthday 用户生日 
     * @support  string $reserve_time 预约时间 [ require true ]
     * @support  int $occupy_num 排单表占点数量 [ require true ]
     * @support  array $detail 订单详情（商品&amp;服务详情） [ require true ]
     * @support  string $module 模块 
     * @support  float $gift_card_money 礼品卡抵扣金额 [Original type double] 
     * @support  int $coupon_id 优惠券ID 
     * @support  float $coupon_deduction_money 优惠券优惠金额 [Original type unsignedDouble] 
     * @support  int $product_card_id 产品卡ID 
     * @support  float $product_card_deduction_money 产品卡优惠金额 [Original type unsignedDouble] 
     * @support  array $product_discount_ids 组合优惠id 
     * @support  float $product_discount_deduction_money 组合优惠优惠金额 [Original type unsignedDouble] 
     * @support  string $interior_coupon_code 开单折扣码 
     * @support  string $type 订单类型 [ require true ]
     * @support  string $note 订单备注 
     * @support  string $outside_city 拍摄城市 
     * @support  string $outside_address 拍摄详细地址 
     * @support  string $discount_scene 改价选项 
     * @support  int $partner_no 伙伴工号（伙伴改价场景需要） 
     * @support  float $input_real_money 手动输入的实际价格（改价时需要） [Original type double] 
     * @support  string $create_mode 订单创建模式 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 团购优惠订单创建
     *
     * @support  int $user_id 用户ID 
     * @support  string $user_phone 用户手机号 [ require true ]
     * @support  string $user_sex 用户性别 [ require true ]
     * @support  string $user_name 用户姓名 [ require true ]
     * @support  string $user_birthday 用户生日 
     * @support  string $reserve_time 预约时间 [ require true ]
     * @support  array $detail 订单详情（商品&amp;服务详情） [ require true ]
     * @support  array $group_order_item_ids 团购订单产品ids [ require true ]
     * @support  string $note 订单备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function groupOrderCreate () {
        return self::getClass()->groupOrderCreate();
    }

    /**
     * 绑定用户
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $user_id 用户ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function bindUser (int $id, int $user_id) {
        return self::getClass()->bindUser([
            "id" => $id,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 取消绑定用户
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function unbindUser (int $id) {
        return self::getClass()->unbindUser([
            "id" => $id,
        ]);
    }

    /**
     * 修改订单所属用户
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @support  string $phone 新绑定用户的手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateUser () {
        return self::getClass()->updateUser();
    }

    /**
     * 提交订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function submit (int $id) {
        return self::getClass()->submit([
            "id" => $id,
        ]);
    }

    /**
     * 取消订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 取消原因 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cancel (int $id, string $reason) {
        return self::getClass()->cancel([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 完成支付
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $pay_type 支付类型 [ require true ]
     * @param  string $payment_no 支付流水号【管理端非必填】 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function paid (int $id, string $pay_type, string $payment_no = '') {
        return self::getClass()->paid([
            "id" => $id,
            "pay_type" => $pay_type,
            "payment_no" => $payment_no,
        ]);
    }

    /**
     * 开始订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function start (int $id) {
        return self::getClass()->start([
            "id" => $id,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id) {
        return self::getClass()->close([
            "id" => $id,
        ]);
    }

    /**
     * 完成订单（拍摄完成）
     *
     * @param  int $id 订单ID [ require true ]
     * @param  array $workloads 工作量数组，staff_id 伙伴ID，staff_type 伙伴类型，work_per 工作占比 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function finish (int $id, array $workloads) {
        return self::getClass()->finish([
            "id" => $id,
            "workloads" => $workloads,
        ]);
    }

    /**
     * 恢复到等待拍摄
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function recoverWaitShooting (int $id) {
        return self::getClass()->recoverWaitShooting([
            "id" => $id,
        ]);
    }

    /**
     * 拍摄完成的订单恢复到等待拍摄
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function recoverFinishedToWaitShooting (int $id) {
        return self::getClass()->recoverFinishedToWaitShooting([
            "id" => $id,
        ]);
    }

    /**
     * 修改预约时间
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reserve_time 预约时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeReserveTime (int $id, string $reserve_time) {
        return self::getClass()->changeReserveTime([
            "id" => $id,
            "reserve_time" => $reserve_time,
        ]);
    }

    /**
     * 修改用户数据
     *
     * @support  int $id 订单ID [ require true ]
     * @support  string $user_name 用户姓名 [ require true ]
     * @support  string $user_sex 用户姓名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserData () {
        return self::getClass()->changeUserData();
    }

    /**
     * 删除订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 用户可用优惠券列表
     *
     * @support  array $product_ids 产品ids [ require true ]
     * @support  int $user_id 用户ID [ require true ]
     * @support  string $order_time 使用时间 [ require true ]
     * @support  string $apply_in 应用于 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCanUseCouponList () {
        return self::getClass()->getCanUseCouponList();
    }

    /**
     * 用户可用产品卡列表
     *
     * @support  array $product_ids 产品ids [ require true ]
     * @support  int $user_id 用户ID [ require true ]
     * @support  string $apply_in 应用于 
     * @throws  \Exception
     * @return  array
     */
    public static function getCanUseProductCardList () {
        return self::getClass()->getCanUseProductCardList();
    }

    /**
     * 计算优惠券可抵扣信息
     *
     * @support  array $detail 订单下单详情信息 [ require true ]
     * @support  int $coupon_id 优惠券ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function calCouponDeductionInfo () {
        return self::getClass()->calCouponDeductionInfo();
    }

    /**
     * 计算产品卡可抵扣信息
     *
     * @support  array $detail 订单下单详情信息 [ require true ]
     * @support  int $product_card_id 产品卡ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function calProductDeductionInfo () {
        return self::getClass()->calProductDeductionInfo();
    }

    /**
     * 订单开单折扣码抵扣
     *
     * @support  string $interior_coupon_code 开单折扣码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function calInteriorCouponDeductionInfo () {
        return self::getClass()->calInteriorCouponDeductionInfo();
    }

    /**
     * 录入工作量
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  array $workloads 工作量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function workloads () {
        return self::getClass()->workloads();
    }

    /**
     * 检查订单用户是否关注公众号
     *
     * @param  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkUserSubscribe (int $user_id) {
        return self::getClass()->checkUserSubscribe([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 获取加密订单号
     *
     * @param  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getEncryptOrderNum (string $order_num) {
        return self::getClass()->getEncryptOrderNum([
            "order_num" => $order_num,
        ]);
    }

    /**
     * 获取短链接
     *
     * @param  string $order_num 订单号 [ require true ]
     * @param  string $url 付款链接前缀 [ require true ]
     * @param  string $pay_type 类型(首款或者尾款) [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getShortUrl (string $order_num, string $url, string $pay_type = '') {
        return self::getClass()->getShortUrl([
            "order_num" => $order_num,
            "url" => $url,
            "pay_type" => $pay_type,
        ]);
    }

    /**
     * 发送付款链接
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  string $url 付款链接 [ require true ]
     * @param  string $phone 电话号码 [ require true ]
     * @param  string $order_type 订单类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendPayLink (int $order_id, string $url, string $order_type, string $phone) {
        return self::getClass()->sendPayLink([
            "order_id" => $order_id,
            "url" => $url,
            "order_type" => $order_type,
            "phone" => $phone,
        ]);
    }

    /**
     * 重置工作量
     *
     * @support  int $order_id 订单ID [ require true ]
     * @support  array $workloads 工作量数组，staff_id 伙伴ID，staff_type 伙伴类型，work_per 工作占比 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reset () {
        return self::getClass()->reset();
    }

    /**
     * 工作量查询
     *
     * @support  string $order_num 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function workloadDetail () {
        return self::getClass()->workloadDetail();
    }

    /**
     * 修改预约时间【未提交前】
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reserve_time 预约时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeReserveTimeWhenNoSubmit (int $id, string $reserve_time) {
        return self::getClass()->changeReserveTimeWhenNoSubmit([
            "id" => $id,
            "reserve_time" => $reserve_time,
        ]);
    }

    /**
     * 获取当日售卖产品总数
     *
     * @support  string $reserve_time_start 起始时间 
     * @support  string $reserve_time_end 结束时间 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function reserveProductCount () {
        return self::getClass()->reserveProductCount();
    }

    /**
     * 换产品（单个产品）
     *
     * @support  int $sub_order_id 子订单ID [ require true ]
     * @support  int $refund_item_id 退款产品id [ require true ]
     * @support  array $detail 产品详情 [ require true ]
     * @support  float $real_money 手动输入支付金额 [Original type double] 
     * @support  string $pay_type 支付方式 
     * @support  int $input_staff_id 主推人id 
     * @support  int $store_id 门店id 
     * @support  int $order_id 订单id 
     * @support  bool $auto_pay 是否自动完成 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeProduct () {
        return self::getClass()->changeProduct();
    }

    /**
     * 获取用户加修加印券
     *
     * @param  int $user_id 用户id [Original type uint] [ require true ]
     * @param  array $product_ids 订单下单详情信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function jxjyCoupon (int $user_id, array $product_ids) {
        return self::getClass()->jxjyCoupon([
            "user_id" => $user_id,
            "product_ids" => $product_ids,
        ]);
    }

    /**
     * 折扣列表
     *
     * @support  string $ids ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductDiscountByIds () {
        return self::getClass()->getProductDiscountByIds();
    }

    /**
     * 管理端查询订单操作记录
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function operateLog (int $order_id) {
        return self::getClass()->operateLog([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 创建拉卡拉线下支付单
     *
     * @support  string $order_num 订单号或子订单号 [ require true ]
     * @support  float $pay_money 金额 [Original type unsignedDouble] [ require true ]
     * @support  array $extend 扩展字段 
     * @throws  \Exception
     * @return  array
     */
    public static function createPayMaxPayment () {
        return self::getClass()->createPayMaxPayment();
    }

    /**
     * 支付回调
     *
     * @support  string $data 交易返回数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function payMaxCallback () {
        return self::getClass()->payMaxCallback();
    }

    /**
     * 获取订单选衣信息
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderCloth (int $order_id) {
        return self::getClass()->getOrderCloth([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 签到更新性别和到店人数
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  array $items 各产品 [ require true ]
     * @param  int $reached_people_num 到店人数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateOrderCloth (int $order_id, array $items, int $reached_people_num = 0) {
        return self::getClass()->updateOrderCloth([
            "order_id" => $order_id,
            "items" => $items,
            "reached_people_num" => $reached_people_num,
        ]);
    }

    /**
     * 门店新增子订单处理选衣
     *
     * @param  int $order_id 订单id [Original type uint] [ require true ]
     * @param  array $item_ids 子订单itemids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function itemsCheck (int $order_id, array $item_ids) {
        return self::getClass()->itemsCheck([
            "order_id" => $order_id,
            "item_ids" => $item_ids,
        ]);
    }

    /**
     * 定时通知距离预约时间只有一小时的顾客
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronCall () {
        return self::getClass()->cronCall();
    }

    /**
     * 定时检查通话回执
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkCallStatus () {
        return self::getClass()->checkCallStatus();
    }

    /**
     * 定时检查是否需要重拨
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronRedial () {
        return self::getClass()->cronRedial();
    }

    /**
     * hookNotifyCall
     *
     * @param  string $call_id callId [ require true ]
     * @param  int $duration 时长 [ require true ]
     * @param  string $status_code 通话状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookNotifyCall (string $call_id, int $duration, string $status_code) {
        return self::getClass()->hookNotifyCall([
            "call_id" => $call_id,
            "duration" => $duration,
            "status_code" => $status_code,
        ]);
    }

    /**
     * callOrderUser
     *
     * @param  array $order 订单信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function callOrderUser (array $order) {
        return self::getClass()->callOrderUser([
            "order" => $order,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}