<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method staffByParams(array $params)
 * @method newCurrentFinanceFluentByParams(array $params)
 * @method saveBigDataByParams(array $params)
 * @method sendDingNoticeByParams(array $params)
 */
class PerformanceCollect {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 个人绩效统计
     *
     * @support  string $start_time 查询的开始时间 [ require true ]
     * @support  string $stop_time 查询的结束时间 [ require true ]
     * @support  int $staff_id 个人id [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function staff () {
        return self::getClass()->staff();
    }

    /**
     * 新版实时财务流水，往日取自大数据，今日取自实时计算
     *
     * @param  string $start_time 查询的开始时间 [ require true ]
     * @param  string $stop_time 查询的结束时间 [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function newCurrentFinanceFluent (string $start_time, string $stop_time, int $store_id) {
        return self::getClass()->newCurrentFinanceFluent([
            "start_time" => $start_time,
            "stop_time" => $stop_time,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 每天9点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveBigData () {
        return self::getClass()->saveBigData();
    }

    /**
     * 每天15点到17点每10分钟执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendDingNotice () {
        return self::getClass()->sendDingNotice();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\PerformanceCollect');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\PerformanceCollect');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}