<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPurchaseFormByParams(array $params)
 * @method getPurchaseListByParams(array $params)
 * @method getPurchaseByParams(array $params)
 * @method callbackDingProcessByParams(array $params)
 * @method purchaseArrivalCallbackByParams(array $params)
 * @method supplierDeliveryCallbackByParams(array $params)
 * @method autoSaveReceiptRemindByParams(array $params)
 * @method getReceiptRemindByParams(array $params)
 * @method getInventoryRejectRemindByParams(array $params)
 * @method autoCreatePurchaseFormByParams(array $params)
 */
class Purchase {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建采购单
     *
     * @param  int $staffId 员工工号 [Original type uint] [ require true ]
     * @param  array $purchaseInfo 采购信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPurchaseForm (int $staffId, array $purchaseInfo) {
        return self::getClass()->createPurchaseForm([
            "staffId" => $staffId,
            "purchaseInfo" => $purchaseInfo,
        ]);
    }

    /**
     * 采购单列表
     *
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  int $staffId 申请人工号 [Original type uint] 
     * @support  string $status 单据状态 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPurchaseList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getPurchaseList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 采购单详情
     *
     * @param  int $id 采购单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPurchase (int $id) {
        return self::getClass()->getPurchase([
            "id" => $id,
        ]);
    }

    /**
     * 钉钉审批回调
     *
     * @throws  \Exception
     * @return  string
     */
    public static function callbackDingProcess () {
        return self::getClass()->callbackDingProcess();
    }

    /**
     * 采购到达供应商通知
     *
     * @param  string $docid 生成的po的id [ require true ]
     * @param  array $details details [ require true ]
     * @param  string $date_create 采购创建时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function purchaseArrivalCallback (string $docid, array $details, string $date_create = '') {
        return self::getClass()->purchaseArrivalCallback([
            "docid" => $docid,
            "details" => $details,
            "date_create" => $date_create,
        ]);
    }

    /**
     * 供应商发货后通知
     *
     * @param  array $data data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function supplierDeliveryCallback (array $data) {
        return self::getClass()->supplierDeliveryCallback([
            "data" => $data,
        ]);
    }

    /**
     * 记录自动收货通知
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSaveReceiptRemind () {
        return self::getClass()->autoSaveReceiptRemind();
    }

    /**
     * 获取自动收货通知
     *
     * @param  string $storeId 门店id [ require true ]
     * @param  string $staffId 员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getReceiptRemind (string $storeId, string $staffId) {
        return self::getClass()->getReceiptRemind([
            "storeId" => $storeId,
            "staffId" => $staffId,
        ]);
    }

    /**
     * 盘点驳回通知
     *
     * @param  string $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInventoryRejectRemind (string $storeId) {
        return self::getClass()->getInventoryRejectRemind([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 批量创建采购单脚本
     *
     * @param  int $staffId 员工工号 [Original type uint] [ require true ]
     * @param  int $storeId 门店id [Original type uint] [ require true ]
     * @param  array $purchaseInfo 采购信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoCreatePurchaseForm (int $staffId, int $storeId, array $purchaseInfo) {
        return self::getClass()->autoCreatePurchaseForm([
            "staffId" => $staffId,
            "storeId" => $storeId,
            "purchaseInfo" => $purchaseInfo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Erp\Purchase');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Erp\Purchase');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}