<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\NoPaper;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method showByParams(array $params)
 * @method syncByParams(array $params)
 * @method showServicePassByParams(array $params)
 * @method syncServicePassByParams(array $params)
 */
class StaffProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取伙伴通关产品详情
     *
     * @support  int $staff_id 伙伴id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function show () {
        return self::getClass()->show();
    }

    /**
     * 同步伙伴的通关产品信息
     *
     * @support  int $staff_id 伙伴id [ require true ]
     * @support  array $product_ids 产品ids 
     * @throws  \Exception
     * @return  array
     */
    public static function sync () {
        return self::getClass()->sync();
    }

    /**
     * 获取伙伴通关服务详情
     *
     * @support  int $staff_id 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function showServicePass () {
        return self::getClass()->showServicePass();
    }

    /**
     * 同步伙伴的通关服务信息
     *
     * @support  int $staff_id 伙伴id [ require true ]
     * @support  bool $service_pass 服务是否通关 
     * @throws  \Exception
     * @return  array
     */
    public static function syncServicePass () {
        return self::getClass()->syncServicePass();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'NoPaper\StaffProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'NoPaper\StaffProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}