<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkSignByParams(array $params)
 * @method getMaterialCategoriesByParams(array $params)
 * @method getMaterialListByParams(array $params)
 * @method getMaterialByParams(array $params)
 * @method getMaterialsByNameByParams(array $params)
 * @method autoSyncCategoriesByParams(array $params)
 * @method autoSyncMaterialsByParams(array $params)
 */
class Material {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * checkSign
     *
     * @param  string $sign sign [ require true ]
     * @param  string $token token [ require true ]
     * @param  string $timestamp timestamp [ require true ]
     * @support  string $name name 
     * @throws  \Exception
     * @return  string
     */
    public static function checkSign (string $sign, string $token, string $timestamp) {
        return self::getClass()->checkSign([
            "sign" => $sign,
            "token" => $token,
            "timestamp" => $timestamp,
        ]);
    }

    /**
     * 获取物料分类
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMaterialCategories () {
        return self::getClass()->getMaterialCategories();
    }

    /**
     * 获取物料列表(根据门店属性查询)
     *
     * @support  int $categoryId 分类id [Original type uint] 
     * @support  string $name 物料名称 
     * @support  string $storeType 门店类型 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getMaterialList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getMaterial
     *
     * @param  string $code 物料编码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterial (string $code) {
        return self::getClass()->getMaterial([
            "code" => $code,
        ]);
    }

    /**
     * getMaterialsByName
     *
     * @param  string $name 物料名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialsByName (string $name) {
        return self::getClass()->getMaterialsByName([
            "name" => $name,
        ]);
    }

    /**
     * 定时任务(同步物料分类信息)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSyncCategories () {
        return self::getClass()->autoSyncCategories();
    }

    /**
     * 定时任务(同步物料信息)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSyncMaterials () {
        return self::getClass()->autoSyncMaterials();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Erp\Material');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Erp\Material');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}