<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProcessStaffByParams(array $params)
 * @method getOrderBaseInfoByParams(array $params)
 * @method getDresserRemarkByParams(array $params)
 * @method getLastQueueSortByParams(array $params)
 * @method changeStateByCloudByParams(array $params)
 * @method getOriginStaffIdByParams(array $params)
 * @method getOnlineOrderCountByParams(array $params)
 * @method cronAdjustAbnormalSelectStatusByParams(array $params)
 * @method queryStoreEfficiencyByParams(array $params)
 * @method queryAreasByParams(array $params)
 * @method queryStoresByParams(array $params)
 * @method queryStaffsByParams(array $params)
 * @method queryProductsByParams(array $params)
 * @method getOrderStatesWithCountByParams(array $params)
 * @method sendCodeByParams(array $params)
 * @method getNoPaperStoresByParams(array $params)
 * @method getStaffInfoByParams(array $params)
 */
class NoPaper {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单无纸化流程伙伴信息
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProcessStaff (int $order_id) {
        return self::getClass()->getProcessStaff([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取订单基础信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $need 需要的信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderBaseInfo (int $orderId, string $need) {
        return self::getClass()->getOrderBaseInfo([
            "orderId" => $orderId,
            "need" => $need,
        ]);
    }

    /**
     * 获取化妆备注
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getDresserRemark () {
        return self::getClass()->getDresserRemark();
    }

    /**
     * 获取门店在当前等待队列队尾序号
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLastQueueSort (int $orderId, string $type) {
        return self::getClass()->getLastQueueSort([
            "orderId" => $orderId,
            "type" => $type,
        ]);
    }

    /**
     * todo 云图端结束摄影中状态[对外接口先不重构]
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  string $comment 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStateByCloud (string $orderNum, string $comment = '') {
        return self::getClass()->changeStateByCloud([
            "orderNum" => $orderNum,
            "comment" => $comment,
        ]);
    }

    /**
     * 获取上一个化妆师id
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOriginStaffId (int $orderId) {
        return self::getClass()->getOriginStaffId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取在线订单状态数量
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getOnlineOrderCount () {
        return self::getClass()->getOnlineOrderCount();
    }

    /**
     * 定时清理伙伴选片状态异常订单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronAdjustAbnormalSelectStatus () {
        return self::getClass()->cronAdjustAbnormalSelectStatus();
    }

    /**
     * [管]门店效率查询
     *
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @support  int $area_id 区域id 
     * @support  int $store_id 门店id 
     * @support  int $product_id 产品id 
     * @param  int $page 页数 [ require true ]
     * @param  int $page_size 每页条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryStoreEfficiency (int $page = 1, int $page_size = 10) {
        return self::getClass()->queryStoreEfficiency([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * [管]门店区域列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function queryAreas () {
        return self::getClass()->queryAreas();
    }

    /**
     * [管]门店列表
     *
     * @param  string $classification_nums 区域id;用,隔开 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryStores (string $classification_nums = '') {
        return self::getClass()->queryStores([
            "classification_nums" => $classification_nums,
        ]);
    }

    /**
     * [管]门店下的伙伴列表
     *
     * @param  int $store_id 门店id [ require true ]
     * @param  string $staff_type 伙伴类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryStaffs (int $store_id, string $staff_type) {
        return self::getClass()->queryStaffs([
            "store_id" => $store_id,
            "staff_type" => $staff_type,
        ]);
    }

    /**
     * [管]产品列表
     *
     * @support  int $store_id 门店id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryProducts () {
        return self::getClass()->queryProducts();
    }

    /**
     * 获取带数量的订单状态列表
     *
     * @param  int $store_id 店铺id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderStatesWithCount (int $store_id) {
        return self::getClass()->getOrderStatesWithCount([
            "store_id" => $store_id,
        ]);
    }

    /**
     * [管]订单绑定发送验证码
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendCode (string $phone, string $order_num) {
        return self::getClass()->sendCode([
            "phone" => $phone,
            "order_num" => $order_num,
        ]);
    }

    /**
     * [管]获取无纸化门店列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoPaperStores () {
        return self::getClass()->getNoPaperStores();
    }

    /**
     * [钉]
     *
     * @param  int $staff_id staffid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffInfo (int $staff_id) {
        return self::getClass()->getStaffInfo([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Order\NoPaper');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Order\NoPaper');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}