<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Order\NoPaper;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderListByParams(array $params)
 * @method getOrderAllPendingStatusByParams(array $params)
 * @method addReceptionistRecordByParams(array $params)
 * @method adjustOrderStatusByParams(array $params)
 * @method getLastQueueSortByParams(array $params)
 * @method giveOrderToStaffInManageByParams(array $params)
 * @method getStaffWorkStatesByParams(array $params)
 */
class NoPaper {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单列表
     *
     * @support  string $mobile 手机号 
     * @support  string $user_name 姓名 
     * @support  string $order_num 订单号 
     * @support  array $status 订单状态 
     * @support  array $pending_status 无纸化订单状态 
     * @support  string $reserve_time_start 预约开始时间 
     * @support  string $reserve_time_end 预约结束时间 
     * @support  array $store_ids 门店ids [ require true ]
     * @support  string $status_auto 自动判断类型, 关闭、今日拍摄自动判断传入参数，进行对应的设置, close、today_shooting。(嫌麻烦的可以使用这个) 
     * @param  int $page 页数 [ require true ]
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderList (int $page = 1) {
        return self::getClass()->getOrderList([
            "page" => $page,
        ]);
    }

    /**
     * 获取当前门店下所有订单的状态[done]
     *
     * @param  int $store_id 店铺id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderAllPendingStatus (int $store_id) {
        return self::getClass()->getOrderAllPendingStatus([
            "store_id" => $store_id,
        ]);
    }

    /**
     * 前台签到排队[done]
     *
     * @support  int $staff_id 员工id [ require true ]
     * @support  int $order_id 订单id [ require true ]
     * @support  string $pending_status 无纸化状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addReceptionistRecord () {
        return self::getClass()->addReceptionistRecord();
    }

    /**
     * 调整订单等待状态和优先级
     *
     * @support  string $queue_type 等待状态类型 [ require true ]
     * @support  int $order_id 订单id [ require true ]
     * @support  int $sort 队列优先级序号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function adjustOrderStatus () {
        return self::getClass()->adjustOrderStatus();
    }

    /**
     * 获取门店在当前等待队列队尾序号[done]
     *
     * @support  int $store_id 门店id 
     * @support  string $type 类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLastQueueSort () {
        return self::getClass()->getLastQueueSort();
    }

    /**
     * 管理端分配订单给某人
     *
     * @support  string $staff_type 用户类型 [ require true ]
     * @support  int $to_staff_id 分配给某人 [ require true ]
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function giveOrderToStaffInManage () {
        return self::getClass()->giveOrderToStaffInManage();
    }

    /**
     * 获取伙伴当前工作状态[done]
     *
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffWorkStates () {
        return self::getClass()->getStaffWorkStates();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Order\NoPaper\NoPaper');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Order\NoPaper\NoPaper');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}