<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method moneyByParams(array $params)
 * @method reasonByParams(array $params)
 */
class OrderRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预约退款录入
     *
     * @support  string $order_num 订单编号 
     * @support  string $order_id 订单id 
     * @support  string $refund_type 退款类型 [ require true ]
     * @support  float $refund_money 退款金额 [Original type double] [ require true ]
     * @support  string $refund_part 退款部分 
     * @support  int $refund_goods_id 其他退款类型需要的商品ID 
     * @support  string $refund_content 退款内容 (只有退款至礼品卡会使用此字段 : all : 全部 order: 初始支付 ds_all: 全部二销，{$ds_sku_id} : ds 产品id) 
     * @support  string $refund_people 退款人 [ require true ]
     * @support  string $refund_account 退款账户 [ require true ]
     * @support  int $refund_scale 退款比例 [ require true ]
     * @support  int $refund_reason 退款原因 [ require true ]
     * @support  bool $is_staff_pay 是否为伙伴垫付 
     * @support  bool $is_refund_card 是否退券 
     * @support  string $refund_note 退款备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * y
     *
     * @support  string $order_num 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function money () {
        return self::getClass()->money();
    }

    /**
     * 退款理由
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reason () {
        return self::getClass()->reason();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\OrderRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\OrderRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}