<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Order\NoPaper;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserInfoByParams(array $params)
 * @method chooseTypeByParams(array $params)
 * @method getStaffStateByParams(array $params)
 * @method getCurrentOrdersByParams(array $params)
 * @method changeStatusByParams(array $params)
 * @method getMessageByParams(array $params)
 * @method takeOrderByParams(array $params)
 * @method completeOrderByParams(array $params)
 * @method getTodayOrdersByParams(array $params)
 * @method dismissOrderByParams(array $params)
 * @method orderAgainByParams(array $params)
 * @method returnToMakeUpByParams(array $params)
 * @method searchCurrentStoreStaffByParams(array $params)
 * @method giveOrderToStaffByParams(array $params)
 * @method getOrderAllPendingStatusByParams(array $params)
 */
class DingDing {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取伙伴信息[done]
     *
     * @support  string $code 钉钉返回的Code 
     * @throws  \Exception
     * @return  array
     */
    public static function getUserInfo () {
        return self::getClass()->getUserInfo();
    }

    /**
     * 选择进入的身份类型[done]
     *
     * @param  int $store_id 门店id [ require true ]
     * @param  string $staff_type 摄影师: cameraman,化妆师: dresser [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function chooseType (int $store_id, string $staff_type) {
        return self::getClass()->chooseType([
            "store_id" => $store_id,
            "staff_type" => $staff_type,
        ]);
    }

    /**
     * 获取用户状态[done]
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getStaffState () {
        return self::getClass()->getStaffState();
    }

    /**
     * 获得当前用户的已接订单[done]
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCurrentOrders () {
        return self::getClass()->getCurrentOrders();
    }

    /**
     * 修改伙伴状态[done]
     *
     * @support  string $last_state 之前的状态 
     * @support  string $now_state 现在的状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStatus () {
        return self::getClass()->changeStatus();
    }

    /**
     * 接单接口 (拿到一条队列数据)[done]
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMessage () {
        return self::getClass()->getMessage();
    }

    /**
     * 伙伴接单[done]
     *
     * @support  int $queue_id 订单id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function takeOrder () {
        return self::getClass()->takeOrder();
    }

    /**
     * 完成订单[done]
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $comment 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function completeOrder () {
        return self::getClass()->completeOrder();
    }

    /**
     * 获取当日订单列表[done]
     *
     * @support  string $phone 手机号 
     * @support  string $pending_status 无纸化订单状态 
     * @throws  \Exception
     * @return  array
     */
    public static function getTodayOrders () {
        return self::getClass()->getTodayOrders();
    }

    /**
     * 退回当前订单, 退回辅助订单
     *
     * @support  int $order_id 订单id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function dismissOrder () {
        return self::getClass()->dismissOrder();
    }

    /**
     * 摄影师手动再来一单[done]
     *
     * @throws  \Exception
     * @return  string
     */
    public static function orderAgain () {
        return self::getClass()->orderAgain();
    }

    /**
     * 订单退回到原化妆师[done]
     *
     * @support  int $order_id 订单id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnToMakeUp () {
        return self::getClass()->returnToMakeUp();
    }

    /**
     * 获取当前可接单的伙伴[done]
     *
     * @throws  \Exception
     * @return  array
     */
    public static function searchCurrentStoreStaff () {
        return self::getClass()->searchCurrentStoreStaff();
    }

    /**
     * 分配订单给某人(辅助化妆)
     *
     * @support  array $to_staff_ids 分配给某人 [ require true ]
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function giveOrderToStaff () {
        return self::getClass()->giveOrderToStaff();
    }

    /**
     * 获取当前门店下所有订单的状态[done]
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderAllPendingStatus () {
        return self::getClass()->getOrderAllPendingStatus();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Order\NoPaper\DingDing');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Order\NoPaper\DingDing');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}