<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Erp;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPurchaseFormByParams(array $params)
 * @method getPurchaseListByParams(array $params)
 * @method getPurchaseByParams(array $params)
 * @method callbackDingProcessByParams(array $params)
 * @method autoSaveReceiptRemindByParams(array $params)
 * @method getReceiptRemindByParams(array $params)
 * @method getInventoryRejectRemindByParams(array $params)
 * @method syncPurchaseOrderByParams(array $params)
 * @method syncPurchaseMaterialSkuByParams(array $params)
 * @method syncUpdatePurchaseStatusByParams(array $params)
 * @method syncUpdateMaterialSkuStatusByParams(array $params)
 * @method syncCreateLogisticByParams(array $params)
 * @method syncPurchaseSkuStatusByParams(array $params)
 */
class Purchase {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建采购单
     *
     * @param  int $staffId 员工工号 [Original type uint] [ require true ]
     * @param  array $purchaseInfo 采购信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPurchaseForm (int $staffId, array $purchaseInfo) {
        return self::getClass()->createPurchaseForm([
            "staffId" => $staffId,
            "purchaseInfo" => $purchaseInfo,
        ]);
    }

    /**
     * 采购单列表
     *
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  int $staffId 申请人工号 [Original type uint] 
     * @support  string $status 单据状态 
     * @support  int $skuId 物料skuId [Original type uint] 
     * @support  string $logisticsNumber 物流单号 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPurchaseList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getPurchaseList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 采购单详情
     *
     * @param  int $id 采购单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPurchase (int $id) {
        return self::getClass()->getPurchase([
            "id" => $id,
        ]);
    }

    /**
     * 钉钉审批回调
     *
     * @throws  \Exception
     * @return  string
     */
    public static function callbackDingProcess () {
        return self::getClass()->callbackDingProcess();
    }

    /**
     * 记录自动收货通知
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSaveReceiptRemind () {
        return self::getClass()->autoSaveReceiptRemind();
    }

    /**
     * 获取自动收货通知
     *
     * @param  string $storeId 门店id [ require true ]
     * @param  string $staffId 员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getReceiptRemind (string $storeId, string $staffId) {
        return self::getClass()->getReceiptRemind([
            "storeId" => $storeId,
            "staffId" => $staffId,
        ]);
    }

    /**
     * 盘点驳回通知
     *
     * @param  string $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInventoryRejectRemind (string $storeId) {
        return self::getClass()->getInventoryRejectRemind([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 同步 NS 需求订单
     *
     * @param  int $purchaseId 采购需求单id [ require true ]
     * @param  string $purchaseOrder ns采购单号 [ require true ]
     * @param  string $purchasedAt 采购订单创建时间 [ require true ]
     * @param  string $orderNumber 需求单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncPurchaseOrder (int $purchaseId, string $purchaseOrder, string $purchasedAt, string $orderNumber) {
        return self::getClass()->syncPurchaseOrder([
            "purchaseId" => $purchaseId,
            "purchaseOrder" => $purchaseOrder,
            "purchasedAt" => $purchasedAt,
            "orderNumber" => $orderNumber,
        ]);
    }

    /**
     * 同步 NS 需求订单明细
     *
     * @param  int $detail_id 明细id [ require true ]
     * @param  int $purchase_id 采购需求单id [ require true ]
     * @param  int $material_sku_id 采购sku id [ require true ]
     * @param  int $apply_count 申请数量 [ require true ]
     * @param  int $purchase_order NS 返回的单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncPurchaseMaterialSku (int $detail_id, int $purchase_id, int $material_sku_id, int $apply_count, int $purchase_order) {
        return self::getClass()->syncPurchaseMaterialSku([
            "detail_id" => $detail_id,
            "purchase_id" => $purchase_id,
            "material_sku_id" => $material_sku_id,
            "apply_count" => $apply_count,
            "purchase_order" => $purchase_order,
        ]);
    }

    /**
     * 同步 NS 需求订单状态
     *
     * @param  int $purchaseId 采购需求单id [ require true ]
     * @param  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncUpdatePurchaseStatus (int $purchaseId, string $status) {
        return self::getClass()->syncUpdatePurchaseStatus([
            "purchaseId" => $purchaseId,
            "status" => $status,
        ]);
    }

    /**
     * 同步 NS 采购明细状态
     *
     * @param  int $detailId 采购明细id [ require true ]
     * @param  int $purchaseCount 已发货数量 [ require true ]
     * @param  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncUpdateMaterialSkuStatus (int $detailId, int $purchaseCount, string $status) {
        return self::getClass()->syncUpdateMaterialSkuStatus([
            "detailId" => $detailId,
            "purchaseCount" => $purchaseCount,
            "status" => $status,
        ]);
    }

    /**
     * 同步 NS 采购物流明细
     *
     * @support  int $purchase_id 采购id [ require true ]
     * @support  int $purchase_material_id 采购物料id [ require true ]
     * @support  string $supplier 供应商 [ require true ]
     * @support  string $logistics_number 物流单号 [ require true ]
     * @support  string $purchase_order ns采购单号 [ require true ]
     * @support  string $invoice 发货单 [ require true ]
     * @support  string $status 签收状态 [ require true ]
     * @support  int $internal_id ns内部id [ require true ]
     * @support  int $dinternalid ns的dinternalid [ require true ]
     * @support  int $detail_id 采购明细id [ require true ]
     * @support  string $ship_created_at ns发货单创建时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncCreateLogistic () {
        return self::getClass()->syncCreateLogistic();
    }

    /**
     * 同步采购明细的状态
     *
     * @param  int $detailId 采购明细id [Original type uint] [ require true ]
     * @param  string $status 采购明细状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncPurchaseSkuStatus (int $detailId, string $status) {
        return self::getClass()->syncPurchaseSkuStatus([
            "detailId" => $detailId,
            "status" => $status,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Erp\Purchase');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Erp\Purchase');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}