<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderDataByParams(array $params)
 * @method getOrderDataByParams(array $params)
 * @method getOrderAllStatusByParams(array $params)
 * @method setOrderDsDataByParams(array $params)
 * @method storeTrafficStatisticsByParams(array $params)
 * @method changeOrderDataByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method changeOrderUserInfoByParams(array $params)
 * @method changeOrderPayTypeByParams(array $params)
 * @method changeOrderProductByParams(array $params)
 * @method changeMicroOrderProductByParams(array $params)
 * @method transferOrderDataByParams(array $params)
 * @method changeOrderExtendByParams(array $params)
 * @method orderStatusChangRecordTimeByParams(array $params)
 * @method increaseRefundFlowByParams(array $params)
 * @method changeDsPayTypeByParams(array $params)
 * @method changeOrderStateOrPayTypeByParams(array $params)
 * @method callbackChangeOrderInfoByParams(array $params)
 * @method addNewUserByParams(array $params)
 * @method changUserInfoByParams(array $params)
 * @method getOrderInfoByOrderNumByParams(array $params)
 * @method getOrderInfoByParams(array $params)
 * @method changeUserPasswordByParams(array $params)
 * @method changeUserPasswordByMobileByParams(array $params)
 * @method getOneDayProductNumByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * createOrderData
     *
     * @param  array $order_data 订单信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrderData (array $order_data) {
        return self::getClass()->createOrderData([
            "order_data" => $order_data,
        ]);
    }

    /**
     * 搜索订单
     *
     * @param  string $type 搜索类型 [ require true ]
     * @param  string $key 关键词 [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @param  string $name 姓名 [ require true ]
     * @param  string $order_num 订单号 [ require true ]
     * @param  array $status 订单状态 [ require true ]
     * @param  array $store_id 门店id [ require true ]
     * @param  int $page 页数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderData (string $type = '', string $key = '', string $phone = '', string $name = '', string $order_num = '', array $status = [], array $store_id = [], int $page = 1) {
        return self::getClass()->getOrderData([
            "type" => $type,
            "key" => $key,
            "phone" => $phone,
            "name" => $name,
            "order_num" => $order_num,
            "status" => $status,
            "store_id" => $store_id,
            "page" => $page,
        ]);
    }

    /**
     * [管]获取当前店铺下所有订单的状态
     *
     * @param  int $store_id 店铺id [ require true ]
     * @param  bool $today_shooting_filter 是否细分当日拍摄状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderAllStatus (int $store_id, bool $today_shooting_filter = false) {
        return self::getClass()->getOrderAllStatus([
            "store_id" => $store_id,
            "today_shooting_filter" => $today_shooting_filter,
        ]);
    }

    /**
     * 增加ds销售数据
     *
     * @param  int $order_num 订单号 [ require true ]
     * @param  float $money 订单金额 [Original type double] [ require true ]
     * @param  int $pay_type 支付类型 [ require true ]
     * @param  string $ds_type ds类型 [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @param  string $created_at 创建时间 [ require true ]
     * @param  int $old_product 升级原来产品之前 [ require true ]
     * @param  int $old_product_count 老产品人数 [ require true ]
     * @param  int $old_product_sku 老产品sku [ require true ]
     * @param  int $ds_product ds产品号 [ require true ]
     * @param  int $ds_sku ds_Sku [ require true ]
     * @param  int $ds_count ds人数 [ require true ]
     * @param  int $pay_id 操作id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setOrderDsData (int $order_num, float $money, int $pay_type, string $ds_type, int $store_id, string $created_at, int $old_product = 0, int $ds_sku = 0, int $ds_count, int $ds_product = 0, int $pay_id, int $old_product_count = 0, int $old_product_sku = 0) {
        return self::getClass()->setOrderDsData([
            "order_num" => $order_num,
            "money" => $money,
            "pay_type" => $pay_type,
            "ds_type" => $ds_type,
            "store_id" => $store_id,
            "created_at" => $created_at,
            "old_product" => $old_product,
            "ds_sku" => $ds_sku,
            "ds_count" => $ds_count,
            "ds_product" => $ds_product,
            "pay_id" => $pay_id,
            "old_product_count" => $old_product_count,
            "old_product_sku" => $old_product_sku,
        ]);
    }

    /**
     * [管]门店流量统计(流量看板)
     *
     * @param  array $store_ids 门店组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeTrafficStatistics (array $store_ids = []) {
        return self::getClass()->storeTrafficStatistics([
            "store_ids" => $store_ids,
        ]);
    }

    /**
     * 修改订单相关信息
     *
     * @param  string $order_num 订单号 [ require true ]
     * @param  array $order_data 订单相关信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderData (string $order_num = '', array $order_data = []) {
        return self::getClass()->changeOrderData([
            "order_num" => $order_num,
            "order_data" => $order_data,
        ]);
    }

    /**
     * 修改预约时间
     *
     * @param  int $order_num 订单号 [ require true ]
     * @param  string $reserve_time 预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeReserveTime (int $order_num, string $reserve_time) {
        return self::getClass()->changeReserveTime([
            "order_num" => $order_num,
            "reserve_time" => $reserve_time,
        ]);
    }

    /**
     * 修改用户订单信息
     *
     * @param  int $order_num 订单号 [ require true ]
     * @param  string $user_name 订单用户名称 [ require true ]
     * @param  string $sex 订单用户性别 [ require true ]
     * @param  string $phone 订单联系方式人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderUserInfo (int $order_num = 0, string $user_name = '', string $sex = '', string $phone = '') {
        return self::getClass()->changeOrderUserInfo([
            "order_num" => $order_num,
            "user_name" => $user_name,
            "sex" => $sex,
            "phone" => $phone,
        ]);
    }

    /**
     * 修改订单的支付方式
     *
     * @param  int $order_num 订单号 [ require true ]
     * @param  int $pay_type 订单支付方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderPayType (int $order_num = 0, int $pay_type = 1) {
        return self::getClass()->changeOrderPayType([
            "order_num" => $order_num,
            "pay_type" => $pay_type,
        ]);
    }

    /**
     * 修改拍摄内容（仅限证件照和签证照）
     *
     * @param  string $order_num 订单号 [ require true ]
     * @param  int $old_product 原产品id [ require true ]
     * @param  int $old_sku 原sku [ require true ]
     * @param  int $new_product 新产品id [ require true ]
     * @param  int $new_sku 新sku [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderProduct (string $order_num, int $old_product, int $new_product, int $old_sku = 0, int $new_sku = 0) {
        return self::getClass()->changeOrderProduct([
            "order_num" => $order_num,
            "old_product" => $old_product,
            "new_product" => $new_product,
            "old_sku" => $old_sku,
            "new_sku" => $new_sku,
        ]);
    }

    /**
     * 修改拍摄内容
     *
     * @param  string $order_num 订单号 [ require true ]
     * @param  int $old_product 原产品id [ require true ]
     * @param  int $new_product 新产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeMicroOrderProduct (string $order_num, int $old_product, int $new_product) {
        return self::getClass()->changeMicroOrderProduct([
            "order_num" => $order_num,
            "old_product" => $old_product,
            "new_product" => $new_product,
        ]);
    }

    /**
     * 专门店添加新的订单
     *
     * @param  array $order_data 订单信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function transferOrderData (array $order_data = []) {
        return self::getClass()->transferOrderData([
            "order_data" => $order_data,
        ]);
    }

    /**
     * [管]修改订单扩展信息 -- 备注
     *
     * @param  int $order_num 订单号 [ require true ]
     * @param  array $order_data 订单备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderExtend (int $order_num = 0, array $order_data = []) {
        return self::getClass()->changeOrderExtend([
            "order_num" => $order_num,
            "order_data" => $order_data,
        ]);
    }

    /**
     * 修改当前订单的状态
     *
     * @param  int $order_num 订单号 [ require true ]
     * @param  string $status 状态名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderStatusChangRecordTime (int $order_num, string $status) {
        return self::getClass()->orderStatusChangRecordTime([
            "order_num" => $order_num,
            "status" => $status,
        ]);
    }

    /**
     * 增加一条退款流水
     *
     * @param  int $order_num 订单号 [ require true ]
     * @param  int $pay_id 操作人 [ require true ]
     * @param  float $pay_money 流水金额 [Original type double] [ require true ]
     * @param  string $state 订单状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function increaseRefundFlow (int $order_num, int $pay_id, float $pay_money, string $state = '') {
        return self::getClass()->increaseRefundFlow([
            "order_num" => $order_num,
            "pay_id" => $pay_id,
            "pay_money" => $pay_money,
            "state" => $state,
        ]);
    }

    /**
     * 修改二销的支付方式
     *
     * @param  array $update_ds_data 订单id [ require true ]
     * @param  array $delete_ds_data 支付方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeDsPayType (array $update_ds_data = [], array $delete_ds_data = []) {
        return self::getClass()->changeDsPayType([
            "update_ds_data" => $update_ds_data,
            "delete_ds_data" => $delete_ds_data,
        ]);
    }

    /**
     * 修改订单状态和支付方式
     *
     * @param  int $orderNum 订单id [ require true ]
     * @param  string $payType 支付方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderStateOrPayType (int $orderNum, string $payType) {
        return self::getClass()->changeOrderStateOrPayType([
            "orderNum" => $orderNum,
            "payType" => $payType,
        ]);
    }

    /**
     * 支付回调修改订单信息
     *
     * @param  int $orderNum 订单id [ require true ]
     * @param  int $payType 支付方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function callbackChangeOrderInfo (int $orderNum, int $payType) {
        return self::getClass()->callbackChangeOrderInfo([
            "orderNum" => $orderNum,
            "payType" => $payType,
        ]);
    }

    /**
     * 增加一条用户信息
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $password 密码 [ require true ]
     * @param  string $openId 用户openid [ require true ]
     * @param  string $headImg 用户头像 [ require true ]
     * @param  int $sex 用户性别 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addNewUser (string $phone, string $password, string $openId = '', string $headImg = '', int $sex = 1) {
        return self::getClass()->addNewUser([
            "phone" => $phone,
            "password" => $password,
            "openId" => $openId,
            "headImg" => $headImg,
            "sex" => $sex,
        ]);
    }

    /**
     * changUserInfo
     *
     * @param  int $user_id 用户id [ require true ]
     * @param  string $name 名字 [ require true ]
     * @param  string $birth 生日 [ require true ]
     * @param  string $address 地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changUserInfo (int $user_id, string $name = '', string $birth = '', string $address = '') {
        return self::getClass()->changUserInfo([
            "user_id" => $user_id,
            "name" => $name,
            "birth" => $birth,
            "address" => $address,
        ]);
    }

    /**
     * 根据订单号获取订单相关信息
     *
     * @param  int $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderInfoByOrderNum (int $orderNum) {
        return self::getClass()->getOrderInfoByOrderNum([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 根据订单id获取订单详情
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderInfo (int $orderId) {
        return self::getClass()->getOrderInfo([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 修改用户密码
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $password 用户密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserPassword (int $userId, string $password) {
        return self::getClass()->changeUserPassword([
            "userId" => $userId,
            "password" => $password,
        ]);
    }

    /**
     * 根据手机号修改用户密码
     *
     * @param  int $phone 用户手机号 [ require true ]
     * @param  string $password 用户密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserPasswordByMobile (int $phone, string $password) {
        return self::getClass()->changeUserPasswordByMobile([
            "phone" => $phone,
            "password" => $password,
        ]);
    }

    /**
     * getOneDayProductNum
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOneDayProductNum () {
        return self::getClass()->getOneDayProductNum();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}