<?php
namespace Mainto\Bridge\Invokes\HimoProductStore\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method reasonByParams(array $params)
 * @method fastRefundToGiftCardByParams(array $params)
 * @method canRefundDetailByIdsByParams(array $params)
 * @method canRefundChangeListByParams(array $params)
 * @method refundChangeCreateByParams(array $params)
 * @method visaChangeByParams(array $params)
 * @method createAndConfirmByParams(array $params)
 * @method fixRefundAccountByParams(array $params)
 * @method getOrderRefundInfoByParams(array $params)
 * @method removeByParams(array $params)
 */
class OrderRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预约退款录入
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $refund_type 退款类型 
     * @support  array $refund_info 退款项 
     * @support  int $scale 退款比例 
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账号 [ require true ]
     * @support  array $reason_ids 退款ids [ require true ]
     * @support  string $reason 退款理由 [ require true ]
     * @support  bool $is_staff_pay 是否为伙伴垫付 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 退款列表
     *
     * @support  string $order_no 主订单号 
     * @support  string $status 状态 
     * @support  string $brand 品牌 
     * @support  string $status_list 状态组(,拼接) 
     * @support  int $store_id 门店ID 
     * @support  array $store_ids 门店ID 
     * @support  string $pay_type 支付方式 
     * @support  string $apply_time_start 申请时间-开始 
     * @support  string $apply_time_end 申请时间-结束 
     * @support  string $process_time_start 处理时间-开始 
     * @support  string $process_time_end 处理时间-结束 
     * @support  string $complete_time_start 退款完成时间-开始 
     * @support  string $complete_time_end 退款完成时间-结束 
     * @support  int $page  
     * @support  int $page_size  
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 退款详情
     *
     * @support  int $id 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 退款理由
     *
     * @support  string $category 分类：category_user_refund,category_admin_refund [ require true ]
     * @support  int $parent_id  
     * @throws  \Exception
     * @return  mixed
     */
    public static function reason () {
        return self::getClass()->reason();
    }

    /**
     * 快速退款至礼品卡
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $refund_type 退款类型 
     * @support  array $refund_info 退款项 
     * @support  string $people 退款人 [ require true ]
     * @support  string $reason 退款理由 [ require true ]
     * @support  bool $is_staff_pay 是否为伙伴垫付 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function fastRefundToGiftCard () {
        return self::getClass()->fastRefundToGiftCard();
    }

    /**
     * 获取部分子订单项可退金额
     *
     * @support  int $order_id 订单ID [ require true ]
     * @support  array $refund_info 待退款项 [ require true ]
     * @support  string $refund_type 退款类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function canRefundDetailByIds () {
        return self::getClass()->canRefundDetailByIds();
    }

    /**
     * 可转退列表
     *
     * @support  string $order_no 订单号 [ require true ]
     * @support  string $type 转退类型 
     * @throws  \Exception
     * @return  array
     */
    public static function canRefundChangeList () {
        return self::getClass()->canRefundChangeList();
    }

    /**
     * 创建转退
     *
     * @support  int $refund_id 退款ID [ require true ]
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账号 [ require true ]
     * @support  string $reason 退款原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundChangeCreate () {
        return self::getClass()->refundChangeCreate();
    }

    /**
     * 签证/同类互换
     *
     * @support  int $sub_order_id 子订单号 [ require true ]
     * @support  int $input_staff_id 录入人伙伴ID 
     * @support  array $detail 产品详情 [ require true ]
     * @support  int $refund_item_id 退款项id [ require true ]
     * @support  int $service_id 退款项服务id [ require true ]
     * @support  string $type 类型 [ require true ]
     * @support  int $store_id 门店id 
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function visaChange () {
        return self::getClass()->visaChange();
    }

    /**
     * 退款申请并处理
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $refund_type 退款类型 
     * @support  array $refund_info 退款项 
     * @support  int $scale 退款比例 
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账号 [ require true ]
     * @support  array $reason_ids 退款ids [ require true ]
     * @support  string $reason 退款理由 [ require true ]
     * @support  bool $is_staff_pay 是否为伙伴垫付 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  array
     */
    public static function createAndConfirm () {
        return self::getClass()->createAndConfirm();
    }

    /**
     * 支持修改收款人姓名、收款人账户（支付宝账户）不填则不修改
     *
     * @support  int $id 退款ID [ require true ]
     * @support  string $people 退款人 
     * @support  string $account 退款账户 
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixRefundAccount () {
        return self::getClass()->fixRefundAccount();
    }

    /**
     * 获取订单退款信息
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderRefundInfo (string $order_no) {
        return self::getClass()->getOrderRefundInfo([
            "order_no" => $order_no,
        ]);
    }

    /**
     * 删除转退
     *
     * @support  int $refund_change_id 转退ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove () {
        return self::getClass()->remove();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStore', 'Admin\OrderRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStore', 'Admin\OrderRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}