<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method paperlessOrdersByParams(array|Order\PaperlessOrders\PaperlessOrdersCmd $params)
 * @method listByParams(array|Order\ListSafeNamespace\ListCmd $params)
 * @method waitPayOrderDetailByParams(array|Order\WaitPayOrderDetail\DetailCmd $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 无纸化订单列表
     *
     * @var  Order\PaperlessOrders\PaperlessOrdersCmd $cmd $cmd
     * @throws  \Exception
     * @return  Order\PaperlessOrders\PaperlessOrderListDTO
     */
    public static function paperlessOrders (Order\PaperlessOrders\PaperlessOrdersCmd $cmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->paperlessOrders($cmd),
            "\Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http\Order\PaperlessOrders\PaperlessOrderListDTO"
        );
    }


    /**
     * 订单列表
     *
     * @var  Order\ListSafeNamespace\ListCmd $cmd $cmd
     * @throws  \Exception
     * @return  Order\ListSafeNamespace\ListDTO
     */
    public static function list (Order\ListSafeNamespace\ListCmd $cmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->list($cmd),
            "\Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http\Order\ListSafeNamespace\ListDTO"
        );
    }


    /**
     * 待支付订单详情
     *
     * @var  Order\WaitPayOrderDetail\DetailCmd $cmd $cmd
     * @throws  \Exception
     * @return  Order\WaitPayOrderDetail\WaitPayOrderDetailDTO
     */
    public static function waitPayOrderDetail (Order\WaitPayOrderDetail\DetailCmd $cmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->waitPayOrderDetail($cmd),
            "\Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http\Order\WaitPayOrderDetail\WaitPayOrderDetailDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Order\Http\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Order\Http\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}