<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPayShortLinkByParams(array|Pay\GetPayShortLink\GetPayLinkCmd $params)
 * @method createPaymentByParams(array|Pay\CreatePayment\CreatePaymentCmd $params)
 * @method callBackByParams(array $params)
 * @method callBackTestByParams(array $params)
 */
class Pay {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取支付链接
     *
     * @var  Pay\GetPayShortLink\GetPayLinkCmd $getPayLinkCmd $getPayLinkCmd
     * @throws  \Exception
     * @return  string
     */
    public static function getPayShortLink (Pay\GetPayShortLink\GetPayLinkCmd $getPayLinkCmd) {
        return self::getClass()->getPayShortLink($getPayLinkCmd);
    }


    /**
     * 创建拉卡拉线下支付单
     *
     * @var  Pay\CreatePayment\CreatePaymentCmd $comment $comment
     * @throws  \Exception
     * @return  Pay\CreatePayment\PaymentDTO
     */
    public static function createPayment (Pay\CreatePayment\CreatePaymentCmd $comment) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->createPayment($comment),
            "\Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http\Pay\CreatePayment\PaymentDTO"
        );
    }


    /**
     * 支付回调
     *
     * @param  string $data 交易数据 [ require true ]
     * @param  string $sign 签名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function callBack (string $data, string $sign) {
        return self::getClass()->callBack([
            "data" => $data,
            "sign" => $sign,
        ]);
    }

    /**
     * WARN 测试环境使用
     *
     * @param  array $data 测试数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function callBackTest (array $data) {
        return self::getClass()->callBackTest([
            "data" => $data,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Order\Http\Pay');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Order\Http\Pay');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}