<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method prepareByParams(array|Dianping\Prepare\DianpingPrepareCmd $params)
 * @method createPaymentByParams(array|Dianping\CreatePayment\DianpingCreatePaymentCmd $params)
 * @method sendCouponByParams(array|Dianping\SendCoupon\DianpingSendCouponCmd $params)
 */
class Dianping {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询美团点评券码
     *
     * @var  Dianping\Prepare\DianpingPrepareCmd $cmd $cmd
     * @throws  \Exception
     * @return  Dianping\Prepare\DianpingReceiptInfoDTO
     */
    public static function prepare (Dianping\Prepare\DianpingPrepareCmd $cmd) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->prepare($cmd),
            "\Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http\Dianping\Prepare\DianpingReceiptInfoDTO"
        );
    }


    /**
     * 创建美团大众点评支付单
     *
     * @var  Dianping\CreatePayment\DianpingCreatePaymentCmd $cmd $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function createPayment (Dianping\CreatePayment\DianpingCreatePaymentCmd $cmd) {
        return self::getClass()->createPayment($cmd);
    }


    /**
     * 美团点评订单签到时发券
     *
     * @var  Dianping\SendCoupon\DianpingSendCouponCmd $cmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function sendCoupon (Dianping\SendCoupon\DianpingSendCouponCmd $cmd) {
        return self::getClass()->sendCoupon($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Order\Http\Dianping');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Order\Http\Dianping');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}