<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method firstSalePaidByParams(array|OrderDiff\FirstSalePaid\SetPaidCmd $params)
 * @method dsSalePaidByParams(array|OrderDiff\DsSalePaid\SetPaidCmd $params)
 * @method userReachedPaidByParams(array|OrderDiff\UserReachedPaid\UserReachedPaidCmd $params)
 * @method giftCardWithholdByParams(array|OrderDiff\GiftCardWithhold\GiftCardWithholdCmd $params)
 * @method marketCardWithholdByParams(array|OrderDiff\MarketCardWithhold\MarketCardWithholdCmd $params)
 * @method cancelByParams(array|OrderDiff\Cancel\CancelCmd $params)
 */
class OrderDiff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 一销支付
     *
     * @var  OrderDiff\FirstSalePaid\SetPaidCmd $cmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function firstSalePaid (OrderDiff\FirstSalePaid\SetPaidCmd $cmd) {
        return self::getClass()->firstSalePaid($cmd);
    }


    /**
     * 二销支付
     *
     * @var  OrderDiff\DsSalePaid\SetPaidCmd $cmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function dsSalePaid (OrderDiff\DsSalePaid\SetPaidCmd $cmd) {
        return self::getClass()->dsSalePaid($cmd);
    }


    /**
     * 签到超人补收支付
     *
     * @var  OrderDiff\UserReachedPaid\UserReachedPaidCmd $cmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function userReachedPaid (OrderDiff\UserReachedPaid\UserReachedPaidCmd $cmd) {
        return self::getClass()->userReachedPaid($cmd);
    }


    /**
     * 使用礼品卡预扣
     *
     * @var  OrderDiff\GiftCardWithhold\GiftCardWithholdCmd $cmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function giftCardWithhold (OrderDiff\GiftCardWithhold\GiftCardWithholdCmd $cmd) {
        return self::getClass()->giftCardWithhold($cmd);
    }


    /**
     * 使用商场卡预扣
     *
     * @var  OrderDiff\MarketCardWithhold\MarketCardWithholdCmd $cmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function marketCardWithhold (OrderDiff\MarketCardWithhold\MarketCardWithholdCmd $cmd) {
        return self::getClass()->marketCardWithhold($cmd);
    }


    /**
     * 取消未支付订单
     *
     * @var  OrderDiff\Cancel\CancelCmd $cmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function cancel (OrderDiff\Cancel\CancelCmd $cmd) {
        return self::getClass()->cancel($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Order\Http\OrderDiff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Order\Http\OrderDiff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}