<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method paperlessOrdersByParams(array|Order\PaperlessOrders\PaperlessOrdersCommand $params)
 * @method listByParams(array|Order\ListSafeNamespace\ListCommand $params)
 * @method waitPayOrderDetailByParams(array|Order\WaitPayOrderDetail\DetailCommand $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 无纸化订单列表
     *
     * @var  Order\PaperlessOrders\PaperlessOrdersCommand $command $command
     * @throws  \Exception
     * @return  Order\PaperlessOrders\PaperlessOrderListDTO
     */
    public static function paperlessOrders (Order\PaperlessOrders\PaperlessOrdersCommand $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->paperlessOrders($command),
            "\Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http\Order\PaperlessOrders\PaperlessOrderListDTO"
        );
    }


    /**
     * 订单列表
     *
     * @var  Order\ListSafeNamespace\ListCommand $command $command
     * @throws  \Exception
     * @return  Order\ListSafeNamespace\ListDTO
     */
    public static function list (Order\ListSafeNamespace\ListCommand $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->list($command),
            "\Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http\Order\ListSafeNamespace\ListDTO"
        );
    }


    /**
     * 待支付订单详情
     *
     * @var  Order\WaitPayOrderDetail\DetailCommand $command $command
     * @throws  \Exception
     * @return  Order\WaitPayOrderDetail\WaitPayOrderDetailDTO
     */
    public static function waitPayOrderDetail (Order\WaitPayOrderDetail\DetailCommand $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->waitPayOrderDetail($command),
            "\Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http\Order\WaitPayOrderDetail\WaitPayOrderDetailDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Order\Http\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Order\Http\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}