<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\App\Interfaces\Order\Http\Controllers;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|Create\CreateCommand $params)
 * @method listByParams(array|List\ListCommand $params)
 * @method listWithPaperlessByParams(array|ListWithPaperless\ListCommand $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @var  Create\CreateCommand $command $command
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (Create\CreateCommand $command) {
        return self::getClass()->create($command);
    }


    /**
     * 订单列表查询
     *
     * @var  List\ListCommand $command $command
     * @throws  \Exception
     * @return  List\OrderListDTO
     */
    public static function list (List\ListCommand $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->list($command),
            "\Mainto\Bridge\Invokes\HimoProductStoreV2\App\Interfaces\Order\Http\Controllers\List\OrderListDTO"
        );
    }


    /**
     * listWithPaperless
     *
     * @var  ListWithPaperless\ListCommand $command $command
     * @throws  \Exception
     * @return  ListWithPaperless\OrderListDTO
     */
    public static function listWithPaperless (ListWithPaperless\ListCommand $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->listWithPaperless($command),
            "\Mainto\Bridge\Invokes\HimoProductStoreV2\App\Interfaces\Order\Http\Controllers\ListWithPaperless\OrderListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}