<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Store\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method newMsgByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\Cmd\Announcement\AnnouncementListCmd $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\Cmd\Announcement\AnnouncementListCmd $params)
 * @method detailByParams(array $params)
 * @method getPopDetailByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\Cmd\Announcement\AnnouncementPopDetailCmd $params)
 * @method categoryListByParams(array $params)
 * @method readByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\Cmd\Announcement\ReaderCmd $params)
 * @method webSocketTipsByParams(array $params)
 */
class Announcement {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新公告提示
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\Cmd\Announcement\AnnouncementListCmd $cmd
     * @throws  \Exception
     * @return  int
     */
    public static function newMsg (\Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\Cmd\Announcement\AnnouncementListCmd $cmd) {
        return self::getClass()->newMsg($cmd);
    }


    /**
     * 公告列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\Cmd\Announcement\AnnouncementListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\DTO\AnnouncementPageDTO
     */
    public static function list (\Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\Cmd\Announcement\AnnouncementListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\DTO\AnnouncementPageDTO"
        );
    }


    /**
     * 公告详情
     *
     * @param  int $announcementId 公告id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\DTO\AnnouncementDetailDTO
     */
    public static function detail (int $announcementId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "announcementId" => $announcementId,
                        ]),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\DTO\AnnouncementDetailDTO"
        );
    }

    /**
     * 获取弹窗公告
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\Cmd\Announcement\AnnouncementPopDetailCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\DTO\AnnouncementPopsDetailDTO
     */
    public static function getPopDetail (\Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\Cmd\Announcement\AnnouncementPopDetailCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPopDetail($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\DTO\AnnouncementPopsDetailDTO"
        );
    }


    /**
     * 公告板块
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\DTO\AnnouncementCategoryDTO[]
     */
    public static function categoryList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->categoryList(),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\DTO\AnnouncementCategoryDTO[]"
        );
    }

    /**
     * 标记已读
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\Cmd\Announcement\ReaderCmd $readerCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function read (\Mainto\Bridge\Structs\HimoProductStoreV2\Store\Http\Cmd\Announcement\ReaderCmd $readerCmd) {
        return self::getClass()->read($readerCmd);
    }


    /**
     * 触发门店公告弹窗
     *
     * @param  string $messageId 消息id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function webSocketTips (string $messageId) {
        return self::getClass()->webSocketTips([
            "messageId" => $messageId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Store\Http\Announcement');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Store\Http\Announcement');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}