<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-09-03 18:56:43
 */
namespace Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd;

class AppealCmd {
    /**
     * @var  string
     * 订单号
     * validation: 
     */
    public string $orderNo;
    /**
     * @var  string
     * 对账单号（列表中返回）
     * validation: 
     */
    public string $billNo;
    /**
     * @var  string
     * 申请类型
     * validation: type:cashDepositAppealType
     */
    public string $appealType;
    /**
     * @var  null|float
     * 金额
     * validation: 
     */
    public ?float $money = null;
    /**
     * @var  null|float
     * 实际支付金额
     * validation: 
     */
    public ?float $realMoney = null;
    /**
     * @var  string
     * 支付类型
     * validation: required_if:appealType,change_pay_type|type:cashDepositPayType
     */
    public string $payType = "";
    /**
     * @var  null|array
     * 凭证图片（可多张）
     * validation: 
     */
    public ?array $certificate = null;
    /**
     * @var  null|string
     * 备注
     * validation: 
     */
    public ?string $note = null;

    public function __construct (int $staffId = 0, string $orderNo = '', string $billNo = '', int $storeId = 0, string $appealType = '') {
        if (!is_null($staffId)) {
            $this->staffId = $staffId;
        }
        if (!is_null($orderNo)) {
            $this->orderNo = $orderNo;
        }
        if (!is_null($billNo)) {
            $this->billNo = $billNo;
        }
        if (!is_null($storeId)) {
            $this->storeId = $storeId;
        }
        if (!is_null($appealType)) {
            $this->appealType = $appealType;
        }
    }

    public static function create(int $staffId = 0, string $orderNo = '', string $billNo = '', int $storeId = 0, string $appealType = ''): self {
        return new self($staffId, $orderNo, $billNo, $storeId, $appealType);
    }

    public function setOrderNo(string $orderNo): self {
        $this->orderNo = $orderNo;

        return $this;
    }

    public function setBillNo(string $billNo): self {
        $this->billNo = $billNo;

        return $this;
    }

    public function setAppealType(string $appealType): self {
        $this->appealType = $appealType;

        return $this;
    }

    public function setMoney(?float $money): self {
        $this->money = $money;

        return $this;
    }

    public function setRealMoney(?float $realMoney): self {
        $this->realMoney = $realMoney;

        return $this;
    }

    public function setPayType(string $payType): self {
        $this->payType = $payType;

        return $this;
    }

    public function setCertificate(?array $certificate): self {
        $this->certificate = $certificate;

        return $this;
    }

    public function setNote(?string $note): self {
        $this->note = $note;

        return $this;
    }
}