<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-09-03 10:53:53
 */
namespace Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd;

class SetPaidCmd {
    /**
     * @var  int
     * 订单id
     * validation: 
     */
    public int $orderId;
    /**
     * @var  string
     * 支付类型
     * validation: 
     */
    public string $payType;
    /**
     * @var  null|string
     * 支付流水号
     * validation: 
     */
    public ?string $paymentNo = "";
    /**
     * @var  null|string[]
     * 支付凭证
     * validation: 
     */
    public ?array $paymentVouchers = null;
    /**
     * @var  null|string
     * 退款人
     * validation: 
     */
    public ?string $refundUser = null;
    /**
     * @var  null|string
     * 退款账号
     * validation: 
     */
    public ?string $refundAccount = null;
    /**
     * @var  null|string
     * 退款原因
     * validation: 
     */
    public ?string $refundReason = null;
    /**
     * @var  null|bool
     * 是否校验支付凭证
     * validation: 
     */
    public ?bool $isCheckPayment = true;

    public function __construct (int $adminId = 0, int $storeId = 0, int $orderId = 0, string $payType = '') {
        if (!is_null($adminId)) {
            $this->adminId = $adminId;
        }
        if (!is_null($storeId)) {
            $this->storeId = $storeId;
        }
        if (!is_null($orderId)) {
            $this->orderId = $orderId;
        }
        if (!is_null($payType)) {
            $this->payType = $payType;
        }
    }

    public static function create(int $adminId = 0, int $storeId = 0, int $orderId = 0, string $payType = ''): self {
        return new self($adminId, $storeId, $orderId, $payType);
    }

    public function setOrderId(int $orderId): self {
        $this->orderId = $orderId;

        return $this;
    }

    public function setPayType(string $payType): self {
        $this->payType = $payType;

        return $this;
    }

    public function setPaymentNo(?string $paymentNo): self {
        $this->paymentNo = $paymentNo;

        return $this;
    }

    public function setPaymentVouchers(?array $paymentVouchers): self {
        $this->paymentVouchers = $paymentVouchers;

        return $this;
    }

    public function setRefundUser(?string $refundUser): self {
        $this->refundUser = $refundUser;

        return $this;
    }

    public function setRefundAccount(?string $refundAccount): self {
        $this->refundAccount = $refundAccount;

        return $this;
    }

    public function setRefundReason(?string $refundReason): self {
        $this->refundReason = $refundReason;

        return $this;
    }

    public function setIsCheckPayment(?bool $isCheckPayment): self {
        $this->isCheckPayment = $isCheckPayment;

        return $this;
    }
}