<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-20 16:00:44
 */
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 */
class Order {
    private static string $serviceName = "HimoProductStoreV2";

    private static string $className = "Order\\Http\\Order";

    /**
     * 无纸化订单列表
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\PaperlessOrderList\PaperlessOrderListDTO
    */
    public static function paperlessOrders (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\PaperlessOrdersCmd $paperlessOrdersCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->paperlessOrders($paperlessOrdersCmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\PaperlessOrderList\PaperlessOrderListDTO"
        );
    }
    /**
     * 订单列表
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\OrderList\ListDTO
    */
    public static function list (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ListCmd $listCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($listCmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\OrderList\ListDTO"
        );
    }
    /**
     * 待支付订单详情
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\WaitPayOrderDetailDTO
    */
    public static function waitPayOrderDetail (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $detailCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->waitPayOrderDetail($detailCmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\WaitPayOrderDetailDTO"
        );
    }
    /**
     * 获取学生会员标签
     * @return  string
    */
    public static function getMembership (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $detailCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMembership($detailCmd);
    }
    /**
     * 设置学生会员资格
     * @return  bool
    */
    public static function setMembership (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\SetMembershipCmd $setMembershipCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setMembership($setMembershipCmd);
    }
    /**
     * 清除学生会员资格
     * @return  bool
    */
    public static function cleanMembership (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\CleanMembershipCmd $cleanMembershipCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cleanMembership($cleanMembershipCmd);
    }
    /**
     * 创建尾款支付diff
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\OrderWaitPayInfoDTO
    */
    public static function createOrderBalancePayment (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\CreateOrderBalancePaymentCmd $createOrderBalancePaymentCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createOrderBalancePayment($createOrderBalancePaymentCmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\OrderWaitPayInfoDTO"
        );
    }
    /**
     * 获取订单使用的特殊折扣类型
     * @return  string
    */
    public static function getOrderUseSpecialDiscountType (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderUseSpecialDiscountType(["orderId" => $orderId]);
    }
    /**
     * 获取订单使用的叠加优惠信息
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\OrderUseAttachInfoDTO
    */
    public static function getOrderUseAttachInfo (int $orderId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderUseAttachInfo(["orderId" => $orderId]),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\OrderUseAttachInfoDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}