<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-20 14:17:39
 */
namespace Mainto\Bridge\Structs\HimoProductStoreV2\AfterSale\Http\Cmd;

class CreateCommand {
    /**
     * @var  int
     * 订单id
     * validation: 
     */
    public int $orderId;
    /**
     * @var  int
     * 申请原因id
     * validation: 
     */
    public int $reasonId;
    /**
     * @var  string
     * 补充说明
     * validation: 
     */
    public string $additionalNotes;
    /**
     * @var  null|int
     * 选择的补偿id
     * validation: 
     */
    public ?int $compensationId = null;
    /**
     * @var  string
     * 收款帐号
     * validation: 
     */
    public string $receiptAccount;
    /**
     * @var  string
     * 收款人
     * validation: 
     */
    public string $receiptPeople;
    /**
     * @var  float
     * 赔偿金额
     * validation: min:0|not_in:0
     */
    public float $compensationMoney;
    /**
     * @var  string
     * 渠道
     * validation: 
     */
    public string $channel = "store";
    /**
     * @var  string
     * 类型
     * validation: 
     */
    public string $type = "compensation";

    public function __construct (int $inputStaffId = 0, int $storeId = 0, int $orderId = 0, int $reasonId = 0, string $additionalNotes = '', string $receiptAccount = '', string $receiptPeople = '', float $compensationMoney = 0.0) {
        if (!is_null($inputStaffId)) {
            $this->inputStaffId = $inputStaffId;
        }
        if (!is_null($storeId)) {
            $this->storeId = $storeId;
        }
        if (!is_null($orderId)) {
            $this->orderId = $orderId;
        }
        if (!is_null($reasonId)) {
            $this->reasonId = $reasonId;
        }
        if (!is_null($additionalNotes)) {
            $this->additionalNotes = $additionalNotes;
        }
        if (!is_null($receiptAccount)) {
            $this->receiptAccount = $receiptAccount;
        }
        if (!is_null($receiptPeople)) {
            $this->receiptPeople = $receiptPeople;
        }
        if (!is_null($compensationMoney)) {
            $this->compensationMoney = $compensationMoney;
        }
    }

    public static function create(int $inputStaffId = 0, int $storeId = 0, int $orderId = 0, int $reasonId = 0, string $additionalNotes = '', string $receiptAccount = '', string $receiptPeople = '', float $compensationMoney = 0.0): self {
        return new self($inputStaffId, $storeId, $orderId, $reasonId, $additionalNotes, $receiptAccount, $receiptPeople, $compensationMoney);
    }

    public function setOrderId(int $orderId): self {
        $this->orderId = $orderId;

        return $this;
    }

    public function setReasonId(int $reasonId): self {
        $this->reasonId = $reasonId;

        return $this;
    }

    public function setAdditionalNotes(string $additionalNotes): self {
        $this->additionalNotes = $additionalNotes;

        return $this;
    }

    public function setCompensationId(?int $compensationId): self {
        $this->compensationId = $compensationId;

        return $this;
    }

    public function setReceiptAccount(string $receiptAccount): self {
        $this->receiptAccount = $receiptAccount;

        return $this;
    }

    public function setReceiptPeople(string $receiptPeople): self {
        $this->receiptPeople = $receiptPeople;

        return $this;
    }

    public function setCompensationMoney(float $compensationMoney): self {
        $this->compensationMoney = $compensationMoney;

        return $this;
    }

    public function setChannel(string $channel): self {
        $this->channel = $channel;

        return $this;
    }

    public function setType(string $type): self {
        $this->type = $type;

        return $this;
    }
}