<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-23 17:58:30
 */
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\NAS\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class NAS
 */
class NAS {
    private static string $serviceName = "HimoProductStoreV2";

    private static string $className = "NAS\\Http\\NAS";

    /**
     * nas服务端上报ip
     * @return  bool
    */
    public static function reportAddr (\Mainto\Bridge\Structs\HimoProductStoreV2\NAS\Http\Cmd\ReportAddrCmd $reportAddrCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reportAddr($reportAddrCmd);
    }
    /**
     * 查询服务端地址信息
     * @return  array
    */
    public static function queryAddrs (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->queryAddrs(["storeId" => $storeId]);
    }
    /**
     * 获取nas门店ids
     * @return  array
    */
    public static function getStoreIds () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIds();
    }
    /**
     * 上报nas客户端信息
     * @return  bool
    */
    public static function reportClientInfo (\Mainto\Bridge\Structs\HimoProductStoreV2\NAS\Http\Cmd\ReportClientInfoCmd $reportClientInfoCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reportClientInfo($reportClientInfoCmd);
    }
    /**
     * 上报nas服务信息
     * @return  bool
    */
    public static function reportServerInfo (\Mainto\Bridge\Structs\HimoProductStoreV2\NAS\Http\Cmd\ReportServerInfoCmd $reportServerInfoCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->reportServerInfo($reportServerInfoCmd);
    }
    /**
     * 修改激活时间
     * @return  bool
    */
    public static function modifyActivationTime (int $storeId, string $activationTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyActivationTime(["storeId" => $storeId, "activationTime" => $activationTime]);
    }
    /**
     * 连接设备信息
     * @return  array
    */
    public static function connectDevices (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->connectDevices(["storeId" => $storeId]),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\NAS\Http\DTO\NasConnectDeviceDTO[]"
        );
    }
    /**
     * nas门店列表
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\NAS\Http\DTO\NasStoreListDTO
    */
    public static function storeList (?\Mainto\Bridge\Structs\HimoProductStoreV2\NAS\Http\Cmd\StoreListCmd $storeListCmd = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->storeList($storeListCmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\NAS\Http\DTO\NasStoreListDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}