<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-22 13:48:00
 */
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\WebSocket\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class WebSocket
 */
class WebSocket {
    private static string $serviceName = "HimoProductStoreV2";

    private static string $className = "WebSocket\\Http\\WebSocket";

    /**
     * 管理端获取ws签名
     */
    public static function getManageRoomSignature (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getManageRoomSignature();
    }
    /**
     * 管理端加入ws房间
     */
    public static function enterManageRoom (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->enterManageRoom();
    }
    /**
     * 管理端ws消息发送
     */
    public static function relayManageMessage (\Mainto\Bridge\Structs\HimoProductStoreV2\WebSocket\Http\Cmd\ReplyMessageCmd $replyMessageCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->relayManageMessage($replyMessageCmd);
    }
    /**
     * 检查websocket连接是否正常
     */
    public static function checkManageAlive (string $uuid): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkManageAlive(["uuid" => $uuid, ]);
    }
    /**
     * app端获取ws签名
     */
    public static function getAppRoomSignature (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAppRoomSignature();
    }
    /**
     * app端加入ws房间
     */
    public static function enterAppRoom (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->enterAppRoom();
    }
    /**
     * 钉钉端获取ws签名
     */
    public static function getDingRoomSignature (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDingRoomSignature();
    }
    /**
     * 钉钉端加入ws房间
     */
    public static function enterDingRoom (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->enterDingRoom();
    }
    /**
     * 钉钉端ws消息发送
     */
    public static function relayDingMessage (\Mainto\Bridge\Structs\HimoProductStoreV2\WebSocket\Http\Cmd\ReplyMessageCmd $replyMessageCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->relayDingMessage($replyMessageCmd);
    }
    /**
     * 检查websocket连接是否正常
     */
    public static function checkDingAlive (string $uuid): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkDingAlive(["uuid" => $uuid, ]);
    }
    /**
     * 场控看板端获取ws签名
     */
    public static function getStoreExpectRoomSignature (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreExpectRoomSignature();
    }
    /**
     * 场控看板端加入ws房间
     */
    public static function enterStoreExpectRoom (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->enterStoreExpectRoom();
    }
    /**
     * 场控看板端消息广播
     */
    public static function broadcastRefreshEvent (int $storeId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->broadcastRefreshEvent(["storeId" => $storeId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}