<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-22 13:48:00
 */
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Pay
 */
class Pay {
    private static string $serviceName = "HimoProductStoreV2";

    private static string $className = "Order\\Http\\Pay";

    /**
     * 获取支付短链接
     */
    public static function getPayShortLink (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\GetPayLinkCmd $getPayLinkCmd): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPayShortLink($getPayLinkCmd);
    }
    /**
     * 发送支付链接
     */
    public static function sendPayLink (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\SendPayLinkCmd $sendPayLinkCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendPayLink($sendPayLinkCmd);
    }
    /**
     * 创建拉卡拉线下支付单
     */
    public static function createPayment (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\CreatePaymentCmd $createPaymentCmd): \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\PaymentDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createPayment($createPaymentCmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\PaymentDTO"
        );
    }
    /**
     * 支付回调
     */
    public static function callBack (string $data, string $sign) {
        return RpcClass::getClass(self::$serviceName, self::$className)->callBack(["data" => $data, "sign" => $sign, ]);
    }
    /**
     * 支付回调测试
     */
    public static function callBackTest (array $data): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->callBackTest(["data" => $data, ]);
    }
    /**
     * 获取试点门店
     */
    public static function getExperimentalUnitStoreIds (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getExperimentalUnitStoreIds();
    }
    /**
     * 获取预支付链接
     */
    public static function advancePaymentShortLink (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\GetPayLinkCmd $getPayLinkCmd): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->advancePaymentShortLink($getPayLinkCmd);
    }
    /**
     * 创建通用支付链接
     */
    public static function payLinkLocation (string $orderNo): void {
         RpcClass::getClass(self::$serviceName, self::$className)->payLinkLocation(["orderNo" => $orderNo, ]);
    }
    /**
     * 校验用户扫描短链接,返回链接时长
     */
    public static function checkUserScanShortLink (int $orderDiffId): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkUserScanShortLink(["orderDiffId" => $orderDiffId, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}