<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-24 16:34:35
 */
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Store\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class CollectionStore
 */
class CollectionStore {
    private static string $serviceName = "HimoProductStoreV2";

    private static string $className = "Store\\Http\\CollectionStore";

    /**
     * 集合店-监听创建订单关闭集合门店点位
     */
    public static function hookCreateOrder (int $orderId, int $storeId, string $reserveTime = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookCreateOrder(["orderId" => $orderId, "storeId" => $storeId, "reserveTime" => $reserveTime, ]);
    }
    /**
     * 集合店-监听超时关闭订单开启集合门店点位
     */
    public static function hookCancelOrder (int $orderId, int $storeId, string $reserveTime = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookCancelOrder(["orderId" => $orderId, "storeId" => $storeId, "reserveTime" => $reserveTime, ]);
    }
    /**
     * 集合店-监听主动关闭订单开启集合门店点位
     */
    public static function hookCloseOrder (int $orderId, int $storeId, string $reserveTime = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookCloseOrder(["orderId" => $orderId, "storeId" => $storeId, "reserveTime" => $reserveTime, ]);
    }
    /**
     * 集合店-监听修改预约时间处理集合门店点位
     */
    public static function hookPaperlessCloseOrder (int $orderId, int $storeId, string $oriChangeReserveTime, string $changeReserveTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookPaperlessCloseOrder(["orderId" => $orderId, "storeId" => $storeId, "oriChangeReserveTime" => $oriChangeReserveTime, "changeReserveTime" => $changeReserveTime, ]);
    }
    /**
     * 集合店-监听退款处理集合门店点位
     */
    public static function hookOrderRefund (int $orderId, int $storeId, string $refundType, string $reserveTime = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookOrderRefund(["orderId" => $orderId, "storeId" => $storeId, "refundType" => $refundType, "reserveTime" => $reserveTime, ]);
    }
    /**
     * 集合店-监听转门店处理集合门店点位
     */
    public static function hookChangeStore (int $orderId, int $newOrderId, int $oriStoreId, int $newStoreId, string $oriReserveTime, string $reserveTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookChangeStore(["orderId" => $orderId, "newOrderId" => $newOrderId, "oriStoreId" => $oriStoreId, "newStoreId" => $newStoreId, "oriReserveTime" => $oriReserveTime, "reserveTime" => $reserveTime, ]);
    }
    /**
     * 集合店-监听重拍关闭集合门店点位
     */
    public static function hookRetakeUserFlow (int $retakeAfterOrderId, int $retakeAfterStoreId, string $reserveTime = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookRetakeUserFlow(["retakeAfterOrderId" => $retakeAfterOrderId, "retakeAfterStoreId" => $retakeAfterStoreId, "reserveTime" => $reserveTime, ]);
    }
    /**
     * 集合店-监听取消重拍打开集合门店点位
     */
    public static function hookCancelRetakeOrder (int $afterOrderId, int $afterStoreId, string $reserveTime = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookCancelRetakeOrder(["afterOrderId" => $afterOrderId, "afterStoreId" => $afterStoreId, "reserveTime" => $reserveTime, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}