<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-05 18:08:17
 */
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Finance\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class CashDeposit
 */
class CashDeposit {
    private static string $serviceName = "HimoProductStoreV2";

    private static string $className = "Finance\\Http\\CashDeposit";

    /**
     * 现金缴存数据统计
     *
     */
    public static function statistics (\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\StatisticsCmd $statisticsCmd): \Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\DTO\StatisticsDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->statistics($statisticsCmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\DTO\StatisticsDTO"
        );
    }
    /**
     * 现金缴存列表
     *
     */
    public static function list (\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\ListCmd $listCmd): \Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\DTO\ListPageDataDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($listCmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\DTO\ListPageDataDTO"
        );
    }
    /**
     * 发起结算(获取结算单)
     *
     */
    public static function settlement (\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\SettlementCmd $settlementCmd): \Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\DTO\SettlementDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->settlement($settlementCmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\DTO\SettlementDTO"
        );
    }
    /**
     * 现金有误审批
     *
     */
    public static function appeal (\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\AppealCmd $appealCmd): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->appeal($appealCmd);
    }
    /**
     * 修改流水支付方式
     *
     */
    public static function changePayType (\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\ChangePayTypeCmd $changePayTypeCmd): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType($changePayTypeCmd);
    }
    /**
     * 检查核算单是否已支付
     *
     */
    public static function checkPaid (string $billNo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkPaid(["billNo" => $billNo, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}