<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\NAS\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method reportAddrByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\NAS\Http\Cmd\ReportAddrCmd $params)
 * @method queryAddrsByParams(array $params)
 */
class NAS {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * nas服务端上报ip
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\NAS\Http\Cmd\ReportAddrCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function reportAddr (\Mainto\Bridge\Structs\HimoProductStoreV2\NAS\Http\Cmd\ReportAddrCmd $cmd) {
        return self::getClass()->reportAddr($cmd);
    }


    /**
     * nas服务端上报ip
     *
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryAddrs (int $storeId) {
        return self::getClass()->queryAddrs([
            "storeId" => $storeId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'NAS\Http\NAS');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'NAS\Http\NAS');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}