<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\WebSocket\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getManageRoomSignatureByParams(array $params)
 * @method enterManageRoomByParams(array $params)
 * @method relayManageMessageByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\WebSocket\Http\Cmd\ReplyMessageCmd $params)
 * @method checkManageAliveByParams(array $params)
 * @method getDingRoomSignatureByParams(array $params)
 * @method enterDingRoomByParams(array $params)
 * @method relayDingMessageByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\WebSocket\Http\Cmd\ReplyMessageCmd $params)
 * @method checkDingAliveByParams(array $params)
 * @method getStoreExpectRoomSignatureByParams(array $params)
 * @method enterStoreExpectRoomByParams(array $params)
 * @method broadcastRefreshEventByParams(array $params)
 */
class WebSocket {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 管理端获取ws签名
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getManageRoomSignature () {
        return self::getClass()->getManageRoomSignature();
    }

    /**
     * 管理端加入ws房间
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function enterManageRoom () {
        return self::getClass()->enterManageRoom();
    }

    /**
     * 管理端ws消息发送
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\WebSocket\Http\Cmd\ReplyMessageCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function relayManageMessage (\Mainto\Bridge\Structs\HimoProductStoreV2\WebSocket\Http\Cmd\ReplyMessageCmd $cmd) {
        return self::getClass()->relayManageMessage($cmd);
    }


    /**
     * 检查websocket连接是否正常
     *
     * @support  string $uuid UUID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkManageAlive () {
        return self::getClass()->checkManageAlive([
        ]);
    }

    /**
     * 钉钉端获取ws签名
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getDingRoomSignature () {
        return self::getClass()->getDingRoomSignature();
    }

    /**
     * 钉钉端加入ws房间
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function enterDingRoom () {
        return self::getClass()->enterDingRoom();
    }

    /**
     * 钉钉端ws消息发送
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\WebSocket\Http\Cmd\ReplyMessageCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function relayDingMessage (\Mainto\Bridge\Structs\HimoProductStoreV2\WebSocket\Http\Cmd\ReplyMessageCmd $cmd) {
        return self::getClass()->relayDingMessage($cmd);
    }


    /**
     * 检查websocket连接是否正常
     *
     * @support  string $uuid UUID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkDingAlive () {
        return self::getClass()->checkDingAlive([
        ]);
    }

    /**
     * 场控看板端获取ws签名
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreExpectRoomSignature () {
        return self::getClass()->getStoreExpectRoomSignature();
    }

    /**
     * 场控看板端加入ws房间
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function enterStoreExpectRoom () {
        return self::getClass()->enterStoreExpectRoom();
    }

    /**
     * 场控看板端消息广播
     *
     * @support  int $storeId 订单Id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function broadcastRefreshEvent () {
        return self::getClass()->broadcastRefreshEvent([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'WebSocket\Http\WebSocket');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'WebSocket\Http\WebSocket');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}