<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPayShortLinkByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\GetPayLinkCmd $params)
 * @method sendPayLinkByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\SendPayLinkCmd $params)
 * @method createPaymentByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\CreatePaymentCmd $params)
 * @method callBackByParams(array $params)
 * @method callBackTestByParams(array $params)
 * @method getExperimentalUnitStoreIdsByParams(array $params)
 * @method advancePaymentShortLinkByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\GetPayLinkCmd $params)
 * @method payLinkLocationByParams(array $params)
 * @method checkUserScanShortLinkByParams(array $params)
 */
class Pay {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取支付短链接
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\GetPayLinkCmd $payLinkCmd
     * @throws  \Exception
     * @return  string
     */
    public static function getPayShortLink (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\GetPayLinkCmd $payLinkCmd) {
        return self::getClass()->getPayShortLink($payLinkCmd);
    }


    /**
     * 发送支付链接
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\SendPayLinkCmd $sendPayLinkCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function sendPayLink (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\SendPayLinkCmd $sendPayLinkCmd) {
        return self::getClass()->sendPayLink($sendPayLinkCmd);
    }


    /**
     * 创建拉卡拉线下支付单
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\CreatePaymentCmd $comment
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\PaymentDTO
     */
    public static function createPayment (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\CreatePaymentCmd $comment) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createPayment($comment),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\PaymentDTO"
        );
    }


    /**
     * 支付回调
     *
     * @param  string $data 交易数据 [ require true ]
     * @param  string $sign 签名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function callBack (string $data, string $sign) {
        return self::getClass()->callBack([
            "data" => $data,
            "sign" => $sign,
        ]);
    }

    /**
     * WARN 测试环境使用
     *
     * @param  array $data 测试数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function callBackTest (array $data) {
        return self::getClass()->callBackTest([
            "data" => $data,
        ]);
    }

    /**
     * 获取试点门店
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getExperimentalUnitStoreIds () {
        return self::getClass()->getExperimentalUnitStoreIds();
    }

    /**
     * 获取预支付链接
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\GetPayLinkCmd $payLinkCmd
     * @throws  \Exception
     * @return  string
     */
    public static function advancePaymentShortLink (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\GetPayLinkCmd $payLinkCmd) {
        return self::getClass()->advancePaymentShortLink($payLinkCmd);
    }


    /**
     * 创建通用支付链接
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  void
     */
    public static function payLinkLocation (string $orderNo) {
        return self::getClass()->payLinkLocation([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 校验用户扫描短链接,返回链接时长
     *
     * @param  int $orderDiffId 订单待支付id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function checkUserScanShortLink (int $orderDiffId) {
        return self::getClass()->checkUserScanShortLink([
            "orderDiffId" => $orderDiffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Order\Http\Pay');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Order\Http\Pay');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}