<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\AfterSale\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getReasonsByParams(array $params)
 * @method isAlreadyCreateAfterSaleByParams(array $params)
 */
class AfterSaleOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取售后原因
     *
     * @param  string $type 售后单类型 [ require true ]
     * @param  bool $withDel 需要删除的数据 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\AfterSale\Http\DTO\AfterSaleReasonDTO[]
     */
    public static function getReasons (string $type, bool $withDel = false) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getReasons([
                            "type" => $type,
                            "withDel" => $withDel,
                        ]),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\AfterSale\Http\DTO\AfterSaleReasonDTO[]"
        );
    }

    /**
     * 是否已存在售后单
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $type 售后单类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function isAlreadyCreateAfterSale (int $orderId, string $type) {
        return self::getClass()->isAlreadyCreateAfterSale([
            "orderId" => $orderId,
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'AfterSale\Http\AfterSaleOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'AfterSale\Http\AfterSaleOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}