<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\AfterSale\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\AfterSale\Http\Cmd\CreateCommand $params)
 * @method getCompensationInfoByParams(array $params)
 * @method getReasonsByParams(array $params)
 */
class AfterSaleOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建售后单
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\AfterSale\Http\Cmd\CreateCommand $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function create (\Mainto\Bridge\Structs\HimoProductStoreV2\AfterSale\Http\Cmd\CreateCommand $cmd) {
        return self::getClass()->create($cmd);
    }


    /**
     * 获取赔偿信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $type 售后单类型 [ require true ]
     * @param  array $statusArr 售后单状态 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\AfterSale\Http\DTO\CompensationInfoDTO
     */
    public static function getCompensationInfo (int $orderId, string $type, array $statusArr = []) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCompensationInfo([
                            "orderId" => $orderId,
                            "type" => $type,
                            "statusArr" => $statusArr,
                        ]),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\AfterSale\Http\DTO\CompensationInfoDTO"
        );
    }

    /**
     * 获取售后原因
     *
     * @param  string $type 售后单类型 [ require true ]
     * @param  bool $withDel 需要删除的数据 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\AfterSale\Http\DTO\AfterSaleReasonDTO[]
     */
    public static function getReasons (string $type, bool $withDel = false) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getReasons([
                            "type" => $type,
                            "withDel" => $withDel,
                        ]),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\AfterSale\Http\DTO\AfterSaleReasonDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'AfterSale\Http\AfterSaleOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'AfterSale\Http\AfterSaleOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}