<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Finance\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bmsListByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\ListBMSCmd $params)
 * @method markStatusByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\MarkStatusCmd $params)
 */
class CashDepositBMS {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 现金缴存列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\ListBMSCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function bmsList (\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\ListBMSCmd $cmd) {
        return self::getClass()->bmsList($cmd);
    }


    /**
     * 标记缴存状态
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\MarkStatusCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function markStatus (\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\MarkStatusCmd $cmd) {
        return self::getClass()->markStatus($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Finance\Http\CashDepositBMS');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Finance\Http\CashDepositBMS');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}