<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Finance\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method statisticsByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\StatisticsCmd $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\ListCmd $params)
 * @method settlementByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\SettlementCmd $params)
 * @method appealByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\AppealCmd $params)
 * @method changePayTypeByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\ChangePayTypeCmd $params)
 */
class CashDeposit {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 现金缴存数据统计
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\StatisticsCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\DTO\StatisticsDTO
     */
    public static function statistics (\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\StatisticsCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->statistics($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\DTO\StatisticsDTO"
        );
    }


    /**
     * 现金缴存列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\ListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\DTO\ListPageDataDTO
     */
    public static function list (\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\ListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\DTO\ListPageDataDTO"
        );
    }


    /**
     * 发起结算(获取结算单)
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\SettlementCmd $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function settlement (\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\SettlementCmd $cmd) {
        return self::getClass()->settlement($cmd);
    }


    /**
     * 现金有误审批
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\AppealCmd $cmd
     * @throws  \Exception
     * @return  string
     */
    public static function appeal (\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\AppealCmd $cmd) {
        return self::getClass()->appeal($cmd);
    }


    /**
     * 修改流水支付方式
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\ChangePayTypeCmd $cmd
     * @throws  \Exception
     * @return  string
     */
    public static function changePayType (\Mainto\Bridge\Structs\HimoProductStoreV2\Finance\Http\Cmd\ChangePayTypeCmd $cmd) {
        return self::getClass()->changePayType($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Finance\Http\CashDeposit');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Finance\Http\CashDeposit');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}