<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\User\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkCodeByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\User\Http\Cmd\StudentMembershipCmd\CheckCodeCmd $params)
 */
class StudentMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 学生会员核销码验证
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\User\Http\Cmd\StudentMembershipCmd\CheckCodeCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function checkCode (\Mainto\Bridge\Structs\HimoProductStoreV2\User\Http\Cmd\StudentMembershipCmd\CheckCodeCmd $cmd) {
        return self::getClass()->checkCode($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'User\Http\StudentMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'User\Http\StudentMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}