<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Store\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookCreateOrderByParams(array $params)
 * @method hookCancelOrderByParams(array $params)
 * @method hookCloseOrderByParams(array $params)
 * @method hookPaperlessCloseOrderByParams(array $params)
 * @method hookOrderRefundByParams(array $params)
 * @method hookChangeStoreByParams(array $params)
 * @method hookRetakeUserFlowByParams(array $params)
 * @method hookCancelRetakeOrderByParams(array $params)
 */
class CollectionStore {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 集合店-监听创建订单关闭集合门店点位
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @param  string $reserveTime 预约时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCreateOrder (int $orderId, int $storeId, string $reserveTime = null) {
        return self::getClass()->hookCreateOrder([
            "orderId" => $orderId,
            "storeId" => $storeId,
            "reserveTime" => $reserveTime,
        ]);
    }

    /**
     * 集合店-监听超时关闭订单开启集合门店点位
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @param  string $reserveTime 预约时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCancelOrder (int $orderId, int $storeId, string $reserveTime = null) {
        return self::getClass()->hookCancelOrder([
            "orderId" => $orderId,
            "storeId" => $storeId,
            "reserveTime" => $reserveTime,
        ]);
    }

    /**
     * 集合店-监听主动关闭订单开启集合门店点位
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @param  string $reserveTime 预约时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCloseOrder (int $orderId, int $storeId, string $reserveTime = null) {
        return self::getClass()->hookCloseOrder([
            "orderId" => $orderId,
            "storeId" => $storeId,
            "reserveTime" => $reserveTime,
        ]);
    }

    /**
     * 集合店-监听修改预约时间处理集合门店点位
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $oriChangeReserveTime 原预约时间 [ require false ]
     * @support  string $changeReserveTime 预约时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookPaperlessCloseOrder () {
        return self::getClass()->hookPaperlessCloseOrder([
        ]);
    }

    /**
     * 集合店-监听退款处理集合门店点位
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @param  string $refundType 退款类型 [ require true ]
     * @param  string $reserveTime 预约时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookOrderRefund (int $orderId, int $storeId, string $refundType, string $reserveTime = null) {
        return self::getClass()->hookOrderRefund([
            "orderId" => $orderId,
            "storeId" => $storeId,
            "refundType" => $refundType,
            "reserveTime" => $reserveTime,
        ]);
    }

    /**
     * 集合店-监听转门店处理集合门店点位
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $newOrderId 新订单id [ require true ]
     * @support  int $oriStoreId 老门店id [ require true ]
     * @support  int $newStoreId 新门店id [ require true ]
     * @support  string $oriReserveTime 原门店预约点位 [ require false ]
     * @support  string $reserveTime 预约时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookChangeStore () {
        return self::getClass()->hookChangeStore([
        ]);
    }

    /**
     * 集合店-监听重拍关闭集合门店点位
     *
     * @param  int $retakeAfterOrderId 重拍后新建订单的订单id [ require true ]
     * @param  int $retakeAfterStoreId 重拍后新建订单的门店id [ require true ]
     * @param  string $reserveTime 重拍后新建订单的预约时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookRetakeUserFlow (int $retakeAfterOrderId, int $retakeAfterStoreId, string $reserveTime = null) {
        return self::getClass()->hookRetakeUserFlow([
            "retakeAfterOrderId" => $retakeAfterOrderId,
            "retakeAfterStoreId" => $retakeAfterStoreId,
            "reserveTime" => $reserveTime,
        ]);
    }

    /**
     * 集合店-监听取消重拍打开集合门店点位
     *
     * @param  int $afterOrderId 重拍后新建订单的订单id [ require true ]
     * @param  int $afterStoreId 重拍后新建订单的门店id [ require true ]
     * @param  string $reserveTime 重拍后新建订单的预约时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCancelRetakeOrder (int $afterOrderId, int $afterStoreId, string $reserveTime = null) {
        return self::getClass()->hookCancelRetakeOrder([
            "afterOrderId" => $afterOrderId,
            "afterStoreId" => $afterStoreId,
            "reserveTime" => $reserveTime,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Store\Http\CollectionStore');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Store\Http\CollectionStore');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}