<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ThirdRefundCmd\RefundListCmd $params)
 * @method auditRefundByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ThirdRefundCmd\AuditRefundCmd $params)
 */
class ThirdRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 第三方退款列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ThirdRefundCmd\RefundListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\ThirdRefundListDTO
     */
    public static function list (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ThirdRefundCmd\RefundListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\ThirdRefundListDTO"
        );
    }


    /**
     * 审核退款
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ThirdRefundCmd\AuditRefundCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function auditRefund (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ThirdRefundCmd\AuditRefundCmd $cmd) {
        return self::getClass()->auditRefund($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Order\Http\ThirdRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Order\Http\ThirdRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}