<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\RefundChangeCmd\RefundChangeListCmd $params)
 * @method detailByParams(array $params)
 * @method updateRefundUserInfoByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\RefundChangeCmd\RefundUserInfoCmd $params)
 */
class RefundChange {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 转退列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\RefundChangeCmd\RefundChangeListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\RefundChangeListDTO
     */
    public static function list (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\RefundChangeCmd\RefundChangeListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\RefundChangeListDTO"
        );
    }


    /**
     * 转退详情
     *
     * @param  int $refundChangeId 退款 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\RefundChangeDTO
     */
    public static function detail (int $refundChangeId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "refundChangeId" => $refundChangeId,
                        ]),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\RefundChangeDTO"
        );
    }

    /**
     * 修改退款信息
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\RefundChangeCmd\RefundUserInfoCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateRefundUserInfo (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\RefundChangeCmd\RefundUserInfoCmd $cmd) {
        return self::getClass()->updateRefundUserInfo($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Order\Http\RefundChange');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Order\Http\RefundChange');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}