<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\IntelligentScheduling\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method arrangementListByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ArrangementListCmd $params)
 * @method arrangementChangeStaffByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ArrangementChangeStaffCmd $params)
 * @method changeStaffCheckConflictByParams(array $params)
 * @method arrangementMakeUpChangeStaffByParams(array $params)
 */
class Arrangement {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取排单表信息
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ArrangementListCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function arrangementList (\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ArrangementListCmd $cmd) {
        return self::getClass()->arrangementList($cmd);
    }


    /**
     * 排单表内拖拽更改伙伴
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ArrangementChangeStaffCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function arrangementChangeStaff (\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ArrangementChangeStaffCmd $cmd) {
        return self::getClass()->arrangementChangeStaff($cmd);
    }


    /**
     * 更换伙伴检查冲突
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStaffCheckConflict () {
        return self::getClass()->changeStaffCheckConflict();
    }

    /**
     * 化妆中更换伙伴
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function arrangementMakeUpChangeStaff () {
        return self::getClass()->arrangementMakeUpChangeStaff();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'IntelligentScheduling\Http\Arrangement');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'IntelligentScheduling\Http\Arrangement');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}