<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\IntelligentScheduling\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkDataByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAddCmd $params)
 * @method addByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAddCmd $params)
 * @method checkAdjustShiftByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAdjustShiftCmd $params)
 * @method adjustShiftByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAdjustShiftCmd $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleListCmd $params)
 * @method staffSearchByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleSearchStaffCmd $params)
 * @method testGetXStreamIdByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleSearchStaffCmd $params)
 */
class Schedule {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 检查模板是否正确
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAddCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkData (\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAddCmd $cmd) {
        return self::getClass()->checkData($cmd);
    }


    /**
     * 导入伙伴排班
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAddCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function add (\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAddCmd $cmd) {
        return self::getClass()->add($cmd);
    }


    /**
     * 校验班次变更
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAdjustShiftCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkAdjustShift (\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAdjustShiftCmd $cmd) {
        return self::getClass()->checkAdjustShift($cmd);
    }


    /**
     * 调整伙伴班次
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAdjustShiftCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function adjustShift (\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAdjustShiftCmd $cmd) {
        return self::getClass()->adjustShift($cmd);
    }


    /**
     * 门店排班信息查询
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleListCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleListCmd $cmd) {
        return self::getClass()->list($cmd);
    }


    /**
     * 伙伴模糊搜索
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleSearchStaffCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function staffSearch (\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleSearchStaffCmd $cmd) {
        return self::getClass()->staffSearch($cmd);
    }


    /**
     * 测试x stream id
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleSearchStaffCmd $cmd
     * @throws  \Exception
     * @return  string
     */
    public static function testGetXStreamId (\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleSearchStaffCmd $cmd) {
        return self::getClass()->testGetXStreamId($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'IntelligentScheduling\Http\Schedule');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'IntelligentScheduling\Http\Schedule');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}