<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\IntelligentScheduling\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkTemplateByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAddCmd $params)
 * @method addByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAddCmd $params)
 * @method adjustShiftByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAdjustShiftCmd $params)
 * @method setStaffShiftByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleSetStaffShiftCmd $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleListCmd $params)
 */
class Schedule {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 检查模板是否正确
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAddCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkTemplate (\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAddCmd $cmd) {
        return self::getClass()->checkTemplate($cmd);
    }


    /**
     * 增加班次
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAddCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function add (\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAddCmd $cmd) {
        return self::getClass()->add($cmd);
    }


    /**
     * 调整伙伴班次
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAdjustShiftCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function adjustShift (\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleAdjustShiftCmd $cmd) {
        return self::getClass()->adjustShift($cmd);
    }


    /**
     * 设置伙伴班次
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleSetStaffShiftCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function setStaffShift (\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleSetStaffShiftCmd $cmd) {
        return self::getClass()->setStaffShift($cmd);
    }


    /**
     * 门店排班信息查询
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleListCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\ScheduleListCmd $cmd) {
        return self::getClass()->list($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'IntelligentScheduling\Http\Schedule');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'IntelligentScheduling\Http\Schedule');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}