<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method paidByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\SetPaidCmd $params)
 * @method userReachedPaidByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\UserReachedPaidCmd $params)
 * @method giftCardWithholdByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\GiftCardWithholdCmd $params)
 * @method marketCardWithholdByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\MarketCardWithholdCmd $params)
 * @method cancelPreChangeByParams(array $params)
 * @method cancelByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\CancelCmd $params)
 * @method bindDsStaffByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\BindDiffDsPerformance\BindDsStaffCmd $params)
 * @method existPaymentLinkByParams(array $params)
 * @method cleanDiffPaymentLinkByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\CleanDiffPaymentLinkCmd $params)
 */
class OrderDiff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * diff支付
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\SetPaidCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function paid (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\SetPaidCmd $cmd) {
        return self::getClass()->paid($cmd);
    }


    /**
     * 签到超人补收支付
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\UserReachedPaidCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function userReachedPaid (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\UserReachedPaidCmd $cmd) {
        return self::getClass()->userReachedPaid($cmd);
    }


    /**
     * 使用礼品卡预扣
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\GiftCardWithholdCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function giftCardWithhold (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\GiftCardWithholdCmd $cmd) {
        return self::getClass()->giftCardWithhold($cmd);
    }


    /**
     * 使用商场卡预扣
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\MarketCardWithholdCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function marketCardWithhold (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\MarketCardWithholdCmd $cmd) {
        return self::getClass()->marketCardWithhold($cmd);
    }


    /**
     * 取消因为冲突产生的更改产品记录[智能排班]
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelPreChange (int $orderId) {
        return self::getClass()->cancelPreChange([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 取消未支付订单
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\CancelCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function cancel (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\CancelCmd $cmd) {
        return self::getClass()->cancel($cmd);
    }


    /**
     * 绑定二销主推伙伴
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\BindDiffDsPerformance\BindDsStaffCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function bindDsStaff (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\BindDiffDsPerformance\BindDsStaffCmd $cmd) {
        return self::getClass()->bindDsStaff($cmd);
    }


    /**
     * diif是否存在支付链接
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $diffId diffId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function existPaymentLink (int $orderId, int $diffId) {
        return self::getClass()->existPaymentLink([
            "orderId" => $orderId,
            "diffId" => $diffId,
        ]);
    }

    /**
     * 清除diff绑定的支付链接
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\CleanDiffPaymentLinkCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function cleanDiffPaymentLink (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DiffCmd\CleanDiffPaymentLinkCmd $cmd) {
        return self::getClass()->cleanDiffPaymentLink($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Order\Http\OrderDiff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Order\Http\OrderDiff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}