<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method paperlessOrdersByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\PaperlessOrdersCmd $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ListCmd $params)
 * @method waitPayOrderDetailByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $params)
 * @method getMembershipByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $params)
 * @method setMembershipByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\SetMembershipCmd $params)
 * @method cleanMembershipByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\CleanMembershipCmd $params)
 * @method createOrderBalancePaymentByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\CreateOrderBalancePaymentCmd $params)
 * @method todayShootOrderByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 无纸化订单列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\PaperlessOrdersCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\PaperlessOrderList\PaperlessOrderListDTO
     */
    public static function paperlessOrders (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\PaperlessOrdersCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->paperlessOrders($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\PaperlessOrderList\PaperlessOrderListDTO"
        );
    }


    /**
     * 订单列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\OrderList\ListDTO
     */
    public static function list (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\OrderList\ListDTO"
        );
    }


    /**
     * 待支付订单详情
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\WaitPayOrderDetailDTO
     */
    public static function waitPayOrderDetail (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->waitPayOrderDetail($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\WaitPayOrderDetailDTO"
        );
    }


    /**
     * 获取学生会员标签
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $cmd
     * @throws  \Exception
     * @return  string
     */
    public static function getMembership (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $cmd) {
        return self::getClass()->getMembership($cmd);
    }


    /**
     * 设置学生会员资格
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\SetMembershipCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function setMembership (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\SetMembershipCmd $cmd) {
        return self::getClass()->setMembership($cmd);
    }


    /**
     * 清除学生会员资格
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\CleanMembershipCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function cleanMembership (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\CleanMembershipCmd $cmd) {
        return self::getClass()->cleanMembership($cmd);
    }


    /**
     * 创建尾款支付diff
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\CreateOrderBalancePaymentCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\OrderWaitPayInfoDTO
     */
    public static function createOrderBalancePayment (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\OrderCmd\CreateOrderBalancePaymentCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createOrderBalancePayment($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\OrderWaitPayInfoDTO"
        );
    }


    /**
     * 获取今日拍摄单及无纸化信息
     *
     * @param  string $date 查询日期 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\TodayShootOrder\TodayShootOrderDTO[]
     */
    public static function todayShootOrder (string $date) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->todayShootOrder([
                            "date" => $date,
                        ]),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\TodayShootOrder\TodayShootOrderDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Order\Http\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Order\Http\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}