<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\IntelligentScheduling\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method checkChangeProductByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\OrderScheduleChangeProductCheck\OrderScheduleChangeProductCheckCmd $params)
 * @method changeStaffCheckConflictByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\OrderScheduleChangeStaffCheckCmd $params)
 * @method arrangementMakeUpChangeStaffByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\OrderScheduleChangeStaffCheckCmd $params)
 * @method preReservationByParams(array $params)
 */
class OrderSchedule {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 修改拍摄内容校验
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\OrderScheduleChangeProductCheck\OrderScheduleChangeProductCheckCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkChangeProduct (\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\OrderScheduleChangeProductCheck\OrderScheduleChangeProductCheckCmd $cmd) {
        return self::getClass()->checkChangeProduct($cmd);
    }


    /**
     * 更换伙伴检查冲突
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\OrderScheduleChangeStaffCheckCmd $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function changeStaffCheckConflict (\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\OrderScheduleChangeStaffCheckCmd $cmd) {
        return self::getClass()->changeStaffCheckConflict($cmd);
    }


    /**
     * 化妆中更换伙伴
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\OrderScheduleChangeStaffCheckCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function arrangementMakeUpChangeStaff (\Mainto\Bridge\Structs\HimoProductStoreV2\IntelligentScheduling\Http\Cmd\OrderScheduleChangeStaffCheckCmd $cmd) {
        return self::getClass()->arrangementMakeUpChangeStaff($cmd);
    }


    /**
     * 修改产品预占点
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $reservationTime 预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function preReservation (int $orderId, string $reservationTime) {
        return self::getClass()->preReservation([
            "orderId" => $orderId,
            "reservationTime" => $reservationTime,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'IntelligentScheduling\Http\OrderSchedule');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'IntelligentScheduling\Http\OrderSchedule');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}