<?php
namespace Mainto\Bridge\Invokes\HimoProductStoreV2\Order\Http;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method paperlessOrdersByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\PaperlessOrdersCmd $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ListCmd $params)
 * @method waitPayOrderDetailByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $params)
 * @method createByParams(array|\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\CreateCmd $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 无纸化订单列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\PaperlessOrdersCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\PaperlessOrderList\PaperlessOrderListDTO
     */
    public static function paperlessOrders (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\PaperlessOrdersCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->paperlessOrders($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\PaperlessOrderList\PaperlessOrderListDTO"
        );
    }


    /**
     * 订单列表
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\OrderList\ListDTO
     */
    public static function list (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\ListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\Lists\OrderList\ListDTO"
        );
    }


    /**
     * 待支付订单详情
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\WaitPayOrderDetailDTO
     */
    public static function waitPayOrderDetail (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\DetailCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->waitPayOrderDetail($cmd),
            "\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\DTO\WaitPayOrderDetailDTO"
        );
    }


    /**
     * 创建订单
     *
     * @var  \Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\CreateCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function create (\Mainto\Bridge\Structs\HimoProductStoreV2\Order\Http\Cmd\CreateCmd $cmd) {
        return self::getClass()->create($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProductStoreV2', 'Order\Http\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProductStoreV2', 'Order\Http\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}